/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topics;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTopicDeletion
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(TestTopicDeletion.class);
    private final boolean unload = false;
    private final int numBrokers = 2;

    @Override
    public void setupCluster() throws Exception {
        this.brokerEnvs.put("managedLedgerMaxEntriesPerLedger", "10");
        this.brokerEnvs.put("brokerDeleteInactivePartitionedTopicMetadataEnabled", "false");
        this.brokerEnvs.put("brokerDeleteInactiveTopicsEnabled", "false");
        this.setupCluster("");
    }

    @Override
    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        specBuilder.numBrokers(2);
        specBuilder.enableContainerLog(true);
        return specBuilder;
    }

    @Test(dataProvider="ServiceUrls", timeOut=300000L)
    public void testPartitionedTopicForceDeletion(Supplier<String> serviceUrl) throws Exception {
        log.info("Creating tenant and namespace");
        String tenant = "test-partitioned-topic-" + TestTopicDeletion.randomName(4);
        String namespace = tenant + "/ns1";
        String topic = "persistent://" + namespace + "/partitioned-topic";
        int numPartitions = 6;
        int numKeys = 300;
        String subscriptionName = "sub1";
        this.createTenantName(tenant, this.pulsarCluster.getClusterName(), "admin");
        this.createNamespace(namespace);
        this.pulsarCluster.runAdminCommandOnAnyBroker("namespaces", "set-clusters", "--clusters", this.pulsarCluster.getClusterName(), namespace);
        this.pulsarCluster.runAdminCommandOnAnyBroker("namespaces", "set-retention", "--size", "100M", "--time", "100m", namespace);
        this.createPartitionedTopic(topic, 6);
        try (PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();){
            Consumer consumer;
            block17: {
                log.info("Creating consumer");
                consumer = client.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe();
                log.info("Producing messages");
                try (Producer producer = client.newProducer().topic(topic).create();){
                    for (int i = 0; i < 300; ++i) {
                        producer.newMessage().key("" + i).value((Object)("value-" + i).getBytes(StandardCharsets.UTF_8)).sendAsync();
                    }
                    producer.flush();
                    log.info("Successfully wrote {} values", (Object)300);
                }
                log.info("Consuming half of the messages");
                for (int i = 0; i < 150; ++i) {
                    Message m = consumer.receive(1, TimeUnit.MINUTES);
                    log.info("Read value {}", (Object)m.getKey());
                }
                log.info("Deleting the topic");
                try {
                    ContainerExecResult res = this.pulsarCluster.runAdminCommandOnAnyBroker("topics", "delete-partitioned-topic", "--force", topic);
                    Assert.assertNotEquals((Object)0, (Object)res.getExitCode());
                }
                catch (ContainerExecException e) {
                    log.info("Second delete failed with ContainerExecException, could be ok", (Throwable)e);
                    if (e.getMessage().contains("with error code 1")) break block17;
                    Assert.fail((String)"Expected different error code");
                }
            }
            log.info("Close the consumer and delete the topic again");
            consumer.close();
            ContainerExecResult res = this.pulsarCluster.runAdminCommandOnAnyBroker("topics", "delete-partitioned-topic", "--force", topic);
            Assert.assertNotEquals((Object)0, (Object)res.getExitCode());
            Thread.sleep(5000L);
            log.info("Creating the topic again");
            this.createPartitionedTopic(topic, 4);
        }
    }

    private ContainerExecResult createTenantName(String tenantName, String allowedClusterName, String adminRoleName) throws Exception {
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "create", "--allowed-clusters", allowedClusterName, "--admin-roles", adminRoleName, tenantName);
        Assert.assertEquals((long)0L, (long)result.getExitCode());
        return result;
    }

    private ContainerExecResult createNamespace(String Ns) throws Exception {
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("namespaces", "create", "--clusters", this.pulsarCluster.getClusterName(), Ns);
        Assert.assertEquals((long)0L, (long)result.getExitCode());
        return result;
    }

    private ContainerExecResult createPartitionedTopic(String partitionedTopicName, int numPartitions) throws Exception {
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("topics", "create-partitioned-topic", "--partitions", "" + numPartitions, partitionedTopicName);
        Assert.assertEquals((long)0L, (long)result.getExitCode());
        return result;
    }
}

