/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.tls;

import com.google.common.io.Resources;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClientTlsTest
extends PulsarTestSuite {
    private static final String tlsTrustCertsFilePath = ClientTlsTest.loadCertificateAuthorityFile("certs/ca.cert.pem");
    private static final String tlsKeyFilePath = ClientTlsTest.loadCertificateAuthorityFile("client-keys/admin.key-pk8.pem");
    private static final String tlsCertificateFilePath = ClientTlsTest.loadCertificateAuthorityFile("client-keys/admin.cert.pem");

    private static String loadCertificateAuthorityFile(String name) {
        return Resources.getResource((String)("certificate-authority/" + name)).getPath();
    }

    @DataProvider(name="adminUrls")
    public Object[][] adminUrls() {
        return new Object[][]{{ClientTlsTest.stringSupplier(() -> this.getPulsarCluster().getAnyBrokersHttpsServiceUrl())}, {ClientTlsTest.stringSupplier(() -> this.getPulsarCluster().getProxy().getHttpsServiceUrl())}};
    }

    @Override
    @DataProvider(name="serviceUrls")
    public Object[][] serviceUrls() {
        return new Object[][]{{ClientTlsTest.stringSupplier(() -> this.getPulsarCluster().getProxy().getServiceUrlTls())}};
    }

    @Test(dataProvider="adminUrls")
    public void testAdmin(Supplier<String> urlSupplier) throws PulsarAdminException, PulsarClientException {
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(urlSupplier.get()).tlsTrustCertsFilePath(tlsTrustCertsFilePath).tlsKeyFilePath(tlsKeyFilePath).tlsCertificateFilePath(tlsCertificateFilePath).build();
        try {
            admin.tenants().getTenants();
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="serviceUrls")
    public void testClient(Supplier<String> urlSupplier) throws PulsarClientException {
        PulsarClient client = PulsarClient.builder().serviceUrl(urlSupplier.get()).tlsTrustCertsFilePath(tlsTrustCertsFilePath).tlsKeyFilePath(tlsKeyFilePath).tlsCertificateFilePath(tlsCertificateFilePath).build();
        try {
            Producer producer = client.newProducer().topic(UUID.randomUUID().toString()).create();
            try {
                producer.send((Object)"Hello".getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

