/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.suites;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarSQLTestSuite
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(PulsarSQLTestSuite.class);
    public static final int ENTRIES_PER_LEDGER = 100;
    public static final String OFFLOAD_DRIVER = "aws-s3";
    public static final String BUCKET = "pulsar-integtest";
    public static final String ENDPOINT = "http://s3:9090";
    protected Connection connection = null;
    protected PulsarClient pulsarClient = null;

    @Override
    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        specBuilder.queryLastMessage(true);
        specBuilder.clusterName("pulsar-sql-test");
        specBuilder.numBrokers(1);
        specBuilder.maxMessageSize(0xA00000);
        return super.beforeSetupCluster(clusterName, specBuilder);
    }

    @Override
    protected void beforeStartCluster() throws Exception {
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("managedLedgerMaxEntriesPerLedger", String.valueOf(100));
        envMap.put("managedLedgerMinLedgerRolloverTimeMinutes", "0");
        envMap.put("managedLedgerOffloadDriver", OFFLOAD_DRIVER);
        envMap.put("s3ManagedLedgerOffloadBucket", BUCKET);
        envMap.put("s3ManagedLedgerOffloadServiceEndpoint", ENDPOINT);
        for (BrokerContainer brokerContainer : this.pulsarCluster.getBrokers()) {
            brokerContainer.withEnv(envMap);
        }
    }

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
    }

    protected void initJdbcConnection() throws SQLException {
        if (this.pulsarCluster.getPrestoWorkerContainer() == null) {
            log.error("The presto work container isn't exist.");
            return;
        }
        String url = String.format("jdbc:trino://%s", this.pulsarCluster.getPrestoWorkerContainer().getUrl());
        this.connection = DriverManager.getConnection(url, "test", null);
    }

    @Override
    public void tearDownCluster() throws Exception {
        this.close();
        super.tearDownCluster();
    }

    protected void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                log.error("Failed to close sql connection.", (Throwable)e);
            }
        }
        if (this.pulsarClient != null) {
            try {
                this.pulsarClient.close();
            }
            catch (PulsarClientException e) {
                log.error("Failed to close pulsar client.", (Throwable)e);
            }
        }
    }
}

