/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.plugins;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.tests.integration.messaging.TopicMessagingBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEntryFilters
extends TopicMessagingBase {
    private static final String PREFIX = "PULSAR_PREFIX_";

    @Override
    public void setupCluster() throws Exception {
        this.brokerEnvs.put("PULSAR_PREFIX_entryFilterNames", "pattern_filter");
        this.brokerEnvs.put("PULSAR_PREFIX_entryFiltersDirectory", "/pulsar/examples");
        super.setupCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceUrls")
    public void test(Supplier<String> serviceUrlSupplier) throws Exception {
        String serviceUrl = serviceUrlSupplier.get();
        String topicName = this.getNonPartitionedTopic("filtered-topic", true);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl).build();
        try {
            String evenPattern = "^[a-z]+-\\d*[02468]$";
            Producer producer = client.newProducer(Schema.STRING).topic(topicName).enableBatching(false).producerName("producer").create();
            try {
                int messagesToSend = 20;
                for (int i = 0; i < messagesToSend; ++i) {
                    String messageValue = producer.getProducerName() + "-" + i;
                    MessageId messageId = producer.newMessage().value((Object)messageValue).property("filter_property", messageValue).send();
                    Assert.assertNotNull((Object)messageId);
                }
                try (Consumer<String> consumer = this.createConsumer(client, topicName, evenPattern);){
                    this.receiveMessagesCheckOrderAndDuplicate(Collections.singletonList(consumer), messagesToSend / 2);
                }
                consumer = this.createConsumer(client, topicName, null);
                try {
                    this.receiveMessagesCheckOrderAndDuplicate(Collections.singletonList(consumer), messagesToSend);
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private Consumer<String> createConsumer(PulsarClient client, String topicName, String filterPattern) throws Exception {
        ConsumerBuilder builder = client.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName(TestEntryFilters.randomName(8)).subscriptionType(SubscriptionType.Exclusive).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest);
        if (filterPattern != null) {
            builder.subscriptionProperties(Collections.singletonMap("entry_filter_pattern", filterPattern));
        }
        return builder.subscribe();
    }
}

