/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources.debezium;

import com.google.common.base.Preconditions;
import java.util.Collections;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.tests.integration.io.sources.PulsarIOSourceRunner;
import org.apache.pulsar.tests.integration.io.sources.SourceTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class PulsarIODebeziumSourceRunner
extends PulsarIOSourceRunner {
    private static final Logger log = LoggerFactory.getLogger(PulsarIODebeziumSourceRunner.class);
    private String converterClassName;
    private String tenant;
    private String namespace;
    private String sourceName;
    private String outputTopicName;
    private String consumeTopicName;
    private int numMessages;
    private boolean jsonWithEnvelope;
    private PulsarClient client;

    public PulsarIODebeziumSourceRunner(PulsarCluster cluster, String functionRuntimeType, String converterClassName, String tenant, String ns, String sourceName, String outputTopic, int numMessages, boolean jsonWithEnvelope, String consumeTopicName, PulsarClient client) {
        super(cluster, functionRuntimeType);
        this.converterClassName = converterClassName;
        this.tenant = tenant;
        this.namespace = ns;
        this.sourceName = sourceName;
        this.outputTopicName = outputTopic;
        this.numMessages = numMessages;
        this.jsonWithEnvelope = jsonWithEnvelope;
        this.consumeTopicName = consumeTopicName;
        this.client = client;
    }

    @Override
    public <T extends GenericContainer> void testSource(SourceTester<T> sourceTester) throws Exception {
        try {
            this.internalTestSource(sourceTester);
        }
        finally {
            sourceTester.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends GenericContainer> void internalTestSource(SourceTester<T> sourceTester) throws Exception {
        this.prepareSource(sourceTester);
        this.submitSourceConnector(sourceTester, this.tenant, this.namespace, this.sourceName, this.outputTopicName);
        this.getSourceInfoSuccess(sourceTester, this.tenant, this.namespace, this.sourceName);
        Failsafe.with((Policy)this.statusRetryPolicy, (Policy[])new RetryPolicy[0]).run(() -> this.getSourceStatus(this.tenant, this.namespace, this.sourceName));
        Failsafe.with((Policy)this.statusRetryPolicy, (Policy[])new RetryPolicy[0]).run(() -> this.waitForProcessingSourceMessages(this.tenant, this.namespace, this.sourceName, this.numMessages));
        Consumer consumer = this.client.newConsumer(this.getSchema(this.jsonWithEnvelope)).topic(new String[]{this.consumeTopicName}).subscriptionName("debezium-source-tester").subscriptionType(SubscriptionType.Exclusive).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();
        try {
            log.info("[debezium mysql test] create consumer finish. converterName: {}", (Object)this.converterClassName);
            sourceTester.validateSourceResult(consumer, sourceTester.getNumEntriesExpectAfterStart(), null, this.converterClassName);
            int numEntriesToInsert = sourceTester.getNumEntriesToInsert();
            Preconditions.checkArgument((numEntriesToInsert >= 1 ? 1 : 0) != 0);
            for (int i = 1; i <= numEntriesToInsert; ++i) {
                sourceTester.prepareInsertEvent();
                log.info("inserted entry {} of {}", (Object)i, (Object)numEntriesToInsert);
                sourceTester.validateSourceResult(consumer, 1, "INSERT", this.converterClassName);
            }
            sourceTester.prepareUpdateEvent();
            sourceTester.validateSourceResult(consumer, numEntriesToInsert, "UPDATE", this.converterClassName);
            sourceTester.prepareDeleteEvent();
            sourceTester.validateSourceResult(consumer, numEntriesToInsert, "DELETE", this.converterClassName);
            this.deleteSource(this.tenant, this.namespace, this.sourceName);
            this.getSourceInfoNotFound(this.tenant, this.namespace, this.sourceName);
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

