/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PulsarVersionTest
extends TestRetrySupport {
    private static final String clusterNamePrefix = "pulsar-version";
    private PulsarCluster pulsarCluster;

    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(String.format("%s-%s", clusterNamePrefix, RandomStringUtils.randomAlphabetic((int)6))).build();
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
            this.pulsarCluster = null;
        }
    }

    @Test
    public void getVersion() throws Exception {
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("brokers", "version");
        String version = result.getStdout();
        ContainerExecResult adminVersionShortOption = this.pulsarCluster.runAdminCommandOnAnyBroker("-v");
        Assert.assertTrue((boolean)adminVersionShortOption.getStdout().contains(version));
        ContainerExecResult adminVersionLongOption = this.pulsarCluster.runAdminCommandOnAnyBroker("--version");
        Assert.assertTrue((boolean)adminVersionLongOption.getStdout().contains(version));
        ContainerExecResult clientVersionShortOption = this.pulsarCluster.getAnyBroker().execCmd("/pulsar/bin/pulsar-client", "-v");
        Assert.assertTrue((boolean)clientVersionShortOption.getStdout().contains(version));
        ContainerExecResult clientVersionLongOption = this.pulsarCluster.getAnyBroker().execCmd("/pulsar/bin/pulsar-client", "--version");
        Assert.assertTrue((boolean)clientVersionLongOption.getStdout().contains(version));
    }
}

