/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.bookkeeper;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BrokerInstallWithEntryMetadataInterceptorsTest
extends PulsarClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(BrokerInstallWithEntryMetadataInterceptorsTest.class);
    private static final String PREFIX = "PULSAR_PREFIX_";

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setupCluster() throws Exception {
        this.incrementSetupNumber();
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), BrokerInstallWithEntryMetadataInterceptorsTest.randomName(5)).filter(s -> !s.isEmpty()).collect(Collectors.joining("-"));
        this.brokerEnvs.put("PULSAR_PREFIX_exposingBrokerEntryMetadataToClientEnabled", "true");
        this.brokerEnvs.put("PULSAR_PREFIX_brokerEntryMetadataInterceptors", "org.apache.pulsar.common.intercept.AppendBrokerTimestampMetadataInterceptor");
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(1).brokerEnvs(this.brokerEnvs).clusterName(clusterName).build();
        log.info("Setting up cluster {} with {} bookies, {} brokers", new Object[]{spec.clusterName(), spec.numBookies(), spec.numBrokers()});
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
        log.info("Cluster {} is setup", (Object)spec.clusterName());
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void tearDownCluster() throws Exception {
        super.tearDownCluster();
    }

    @Test
    public void testBrokerHttpServerIsRunning() throws Exception {
        ContainerExecResult result = this.pulsarCluster.getAnyBroker().execCmd("/usr/bin/curl", "-X", "GET", "http://localhost:8080/admin/v2/brokers/health");
        AssertJUnit.assertEquals((long)result.getExitCode(), (long)0L);
        AssertJUnit.assertEquals((String)"ok", (String)result.getStdout());
    }
}

