/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.docker;

import java.util.Arrays;

public class ContainerExecResultBytes {
    private final int exitCode;
    private final byte[] stdout;
    private final byte[] stderr;

    private ContainerExecResultBytes(int exitCode, byte[] stdout, byte[] stderr) {
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public static ContainerExecResultBytes of(int exitCode, byte[] stdout, byte[] stderr) {
        return new ContainerExecResultBytes(exitCode, stdout, stderr);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public byte[] getStdout() {
        return this.stdout;
    }

    public byte[] getStderr() {
        return this.stderr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerExecResultBytes)) {
            return false;
        }
        ContainerExecResultBytes other = (ContainerExecResultBytes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExitCode() != other.getExitCode()) {
            return false;
        }
        if (!Arrays.equals(this.getStdout(), other.getStdout())) {
            return false;
        }
        return Arrays.equals(this.getStderr(), other.getStderr());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerExecResultBytes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExitCode();
        result = result * 59 + Arrays.hashCode(this.getStdout());
        result = result * 59 + Arrays.hashCode(this.getStderr());
        return result;
    }

    public String toString() {
        return "ContainerExecResultBytes(exitCode=" + this.getExitCode() + ", stdout=" + Arrays.toString(this.getStdout()) + ", stderr=" + Arrays.toString(this.getStderr()) + ")";
    }
}

