/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.upgrade;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PulsarZKDowngradeTest
extends PulsarClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarZKDowngradeTest.class);
    protected static final int ENTRIES_PER_LEDGER = 1024;

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setupCluster() throws Exception {
        this.incrementSetupNumber();
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), PulsarZKDowngradeTest.randomName(5)).filter(s -> !s.isEmpty()).collect(Collectors.joining("-"));
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(1).clusterName(clusterName).classPathVolumeMounts((Map<String, String>)ImmutableMap.builder().put((Object)"zk-3.5-test-data", (Object)"/pulsar/data/zookeeper/version-2/version-2").build()).build();
        log.info("Setting up cluster {} with {} bookies, {} brokers", new Object[]{spec.clusterName(), spec.numBookies(), spec.numBrokers()});
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
        log.info("Cluster {} is setup", (Object)spec.clusterName());
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void tearDownCluster() throws Exception {
        super.tearDownCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceUrlAndTopics")
    public void testPublishAndConsume(Supplier<String> serviceUrl, boolean isPersistent) throws Exception {
        String topicName = PulsarZKDowngradeTest.generateTopicName("testpubconsume", isPersistent);
        int numMessages = 10;
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
            try {
                Producer producer = client.newProducer(Schema.STRING).topic(topicName).create();
                try {
                    int i;
                    for (i = 0; i < numMessages; ++i) {
                        producer.send((Object)("smoke-message-" + i));
                    }
                    for (i = 0; i < numMessages; ++i) {
                        Message m = consumer.receive();
                        Assert.assertEquals((String)("smoke-message-" + i), (String)((String)m.getValue()));
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

