/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.tests.integration.containers.StandaloneContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.apache.pulsar.tests.integration.topologies.PulsarTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testng.Assert;
import org.testng.annotations.DataProvider;

public abstract class PulsarStandaloneTestBase
extends PulsarTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneTestBase.class);
    protected Network network;
    protected StandaloneContainer container;

    @DataProvider(name="StandaloneServiceUrlAndTopics")
    public Object[][] serviceUrlAndTopics() {
        return new Object[][]{{PulsarStandaloneTestBase.stringSupplier(() -> this.getContainer().getPlainTextServiceUrl()), true}, {PulsarStandaloneTestBase.stringSupplier(() -> this.getContainer().getPlainTextServiceUrl()), false}};
    }

    @DataProvider(name="StandaloneServiceUrlAndHttpUrl")
    public Object[][] serviceUrlAndHttpUrl() {
        return new Object[][]{{PulsarStandaloneTestBase.stringSupplier(() -> this.getContainer().getPlainTextServiceUrl()), PulsarStandaloneTestBase.stringSupplier(() -> this.getContainer().getHttpServiceUrl())}};
    }

    public StandaloneContainer getContainer() {
        return this.container;
    }

    private static Supplier<String> stringSupplier(Supplier<String> supplier) {
        return supplier;
    }

    protected void startCluster(String pulsarImageName) throws Exception {
        this.network = Network.newNetwork();
        String clusterName = PulsarClusterTestBase.randomName(8);
        this.container = (StandaloneContainer)((StandaloneContainer)((StandaloneContainer)new StandaloneContainer(clusterName, pulsarImageName).withNetwork(this.network)).withNetworkAliases(new String[]{"standalone-" + clusterName})).withEnv("PF_stateStorageServiceUrl", "bk://localhost:4181");
        this.container.start();
        log.info("Pulsar cluster {} is up running:", (Object)clusterName);
        log.info("\tBinary Service Url : {}", (Object)this.container.getPlainTextServiceUrl());
        log.info("\tHttp Service Url : {}", (Object)this.container.getHttpServiceUrl());
        ContainerExecResult result = this.container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "policies", "public/default");
        Assert.assertEquals((int)0, (int)result.getExitCode());
        log.info("public/default namespace policies are {}", (Object)result.getStdout());
    }

    protected void stopCluster() throws Exception {
        if (this.container != null) {
            this.container.stop();
            this.container = null;
        }
        if (this.network != null) {
            this.network.close();
            this.network = null;
        }
    }

    protected void dumpFunctionLogs(String name) {
        try {
            String logFile = "/pulsar/logs/functions/public/default/" + name + "/" + name + "-0.log";
            String logs = (String)this.container.copyFileFromContainer(logFile, inputStream -> IOUtils.toString((InputStream)inputStream, (String)"utf-8"));
            log.info("Function {} logs {}", (Object)name, (Object)logs);
        }
        catch (Throwable err) {
            log.info("Cannot download {} logs", (Object)name, (Object)err);
        }
    }
}

