/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.messaging;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.tests.integration.messaging.MessagingBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReaderMessagingTest
extends MessagingBase {
    private static final Logger log = LoggerFactory.getLogger(ReaderMessagingTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceAndAdminUrls")
    public void testReaderReconnectAndRead(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = this.getNonPartitionedTopic("test-reader-reconnect-read", false);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            Reader reader = client.newReader(Schema.STRING).topic(topicName).subscriptionName("test-sub").startMessageId(MessageId.earliest).create();
            try {
                int messagesToSend = 10;
                Producer producer = client.newProducer(Schema.STRING).topic(topicName).enableBatching(false).create();
                try {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        MessageId messageId = producer.newMessage().value((Object)("message-" + i)).send();
                        Assert.assertNotNull((Object)messageId);
                    }
                    for (i = 0; i < 10; ++i) {
                        Message msg = reader.readNext();
                        Assert.assertEquals((String)((String)msg.getValue()), (String)("message-" + i));
                    }
                    PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(adminUrl.get()).build();
                    try {
                        int i2;
                        admin.topics().unload(topicName);
                        for (i2 = 0; i2 < 10; ++i2) {
                            MessageId messageId = producer.newMessage().value((Object)("message-" + i2)).send();
                            Assert.assertNotNull((Object)messageId);
                        }
                        for (i2 = 0; i2 < 10; ++i2) {
                            Message msg = reader.readNext();
                            Assert.assertEquals((String)((String)msg.getValue()), (String)("message-" + i2));
                        }
                        log.info("-- Exiting {} test --", (Object)this.methodName);
                    }
                    finally {
                        if (Collections.singletonList(admin).get(0) != null) {
                            admin.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceAndAdminUrls")
    public void testReaderReconnectAndReadBatchMessages(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        String topicName = this.getNonPartitionedTopic("test-reader-reconnect-read-batch", false);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            Reader reader = client.newReader(Schema.STRING).topic(topicName).subscriptionName("test-sub").startMessageId(MessageId.earliest).create();
            try {
                int messagesToSend = 10;
                Producer producer = client.newProducer(Schema.STRING).topic(topicName).enableBatching(true).batchingMaxPublishDelay(5L, TimeUnit.SECONDS).batchingMaxMessages(5).create();
                try {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        MessageId messageId = producer.newMessage().value((Object)("message-" + i)).send();
                        Assert.assertNotNull((Object)messageId);
                    }
                    for (i = 0; i < 10; ++i) {
                        Message msg = reader.readNext();
                        Assert.assertEquals((String)((String)msg.getValue()), (String)("message-" + i));
                    }
                    PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(adminUrl.get()).build();
                    try {
                        int i2;
                        admin.topics().unload(topicName);
                        for (i2 = 0; i2 < 10; ++i2) {
                            MessageId messageId = producer.newMessage().value((Object)("message-" + i2)).send();
                            Assert.assertNotNull((Object)messageId);
                        }
                        for (i2 = 0; i2 < 10; ++i2) {
                            Message msg = reader.readNext();
                            Assert.assertEquals((String)((String)msg.getValue()), (String)("message-" + i2));
                        }
                        log.info("-- Exiting {} test --", (Object)this.methodName);
                    }
                    finally {
                        if (Collections.singletonList(admin).get(0) != null) {
                            admin.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

