/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources.debezium;

import java.io.Closeable;
import java.util.Map;
import org.apache.pulsar.tests.integration.containers.DebeziumMySQLContainer;
import org.apache.pulsar.tests.integration.io.sources.SourceTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumMySqlSourceTester
extends SourceTester<DebeziumMySQLContainer>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DebeziumMySqlSourceTester.class);
    private static final String NAME = "debezium-mysql";
    private final String pulsarServiceUrl;
    private DebeziumMySQLContainer debeziumMySqlContainer;
    private final PulsarCluster pulsarCluster;

    public DebeziumMySqlSourceTester(PulsarCluster cluster, String converterClassName) {
        super(NAME);
        this.pulsarCluster = cluster;
        this.pulsarServiceUrl = "pulsar://pulsar-proxy:6650";
        this.sourceConfig.put("database.hostname", "debezium-mysql-example");
        this.sourceConfig.put("database.port", "3306");
        this.sourceConfig.put("database.user", "debezium");
        this.sourceConfig.put("database.password", "dbz");
        this.sourceConfig.put("database.server.id", "184054");
        this.sourceConfig.put("database.server.name", "dbserver1");
        this.sourceConfig.put("database.whitelist", "inventory");
        this.sourceConfig.put("database.history.pulsar.service.url", this.pulsarServiceUrl);
        this.sourceConfig.put("key.converter", converterClassName);
        this.sourceConfig.put("value.converter", converterClassName);
        this.sourceConfig.put("topic.namespace", "debezium/mysql-" + (converterClassName.endsWith("AvroConverter") ? "avro" : "json"));
    }

    @Override
    public void setServiceContainer(DebeziumMySQLContainer container) {
        log.info("start debezium mysql server container.");
        this.debeziumMySqlContainer = container;
        this.pulsarCluster.startService("debezium-mysql-example", this.debeziumMySqlContainer);
    }

    @Override
    public void prepareSource() throws Exception {
        log.info("debezium mysql server already contains preconfigured data.");
    }

    @Override
    public void prepareInsertEvent() throws Exception {
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e 'SELECT * FROM inventory.products'");
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e \"INSERT INTO inventory.products(name, description, weight) values('test-debezium', 'This is description', 2.0)\"");
    }

    @Override
    public void prepareUpdateEvent() throws Exception {
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e \"UPDATE inventory.products set description='update description', weight=10 WHERE name='test-debezium'\"");
    }

    @Override
    public void prepareDeleteEvent() throws Exception {
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e 'SELECT * FROM inventory.products'");
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e \"DELETE FROM inventory.products WHERE name='test-debezium'\"");
        this.debeziumMySqlContainer.execCmd("/bin/bash", "-c", "mysql -h 127.0.0.1 -u root -pdebezium -e 'SELECT * FROM inventory.products'");
    }

    @Override
    public Map<String, String> produceSourceMessages(int numMessages) throws Exception {
        log.info("debezium mysql server already contains preconfigured data.");
        return null;
    }

    @Override
    public void close() {
        if (this.pulsarCluster != null) {
            PulsarCluster.stopService("debezium-mysql-example", this.debeziumMySqlContainer);
        }
    }

    public DebeziumMySQLContainer getDebeziumMySqlContainer() {
        return this.debeziumMySqlContainer;
    }
}

