/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.docker;

import org.testng.Assert;

public class ContainerExecResult {
    private final int exitCode;
    private final String stdout;
    private final String stderr;

    public void assertNoOutput() {
        this.assertNoStdout();
        this.assertNoStderr();
    }

    public void assertNoStdout() {
        Assert.assertTrue((boolean)this.stdout.isEmpty(), (String)("stdout should be empty, but was '" + this.stdout + "'"));
    }

    public void assertNoStderr() {
        Assert.assertTrue((boolean)this.stderr.isEmpty(), (String)("stderr should be empty, but was '" + this.stderr + "'"));
    }

    private ContainerExecResult(int exitCode, String stdout, String stderr) {
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public static ContainerExecResult of(int exitCode, String stdout, String stderr) {
        return new ContainerExecResult(exitCode, stdout, stderr);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerExecResult)) {
            return false;
        }
        ContainerExecResult other = (ContainerExecResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExitCode() != other.getExitCode()) {
            return false;
        }
        String this$stdout = this.getStdout();
        String other$stdout = other.getStdout();
        if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
            return false;
        }
        String this$stderr = this.getStderr();
        String other$stderr = other.getStderr();
        return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerExecResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExitCode();
        String $stdout = this.getStdout();
        result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
        String $stderr = this.getStderr();
        result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
        return result;
    }

    public String toString() {
        return "ContainerExecResult(exitCode=" + this.getExitCode() + ", stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ")";
    }
}

