/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.PulsarClusterMetadataTeardown;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ClusterMetadataTearDownTest
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetadataTearDownTest.class);
    private final PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName("ClusterMetadataTearDownTest-" + UUID.randomUUID().toString().substring(0, 8)).numProxies(0).numFunctionWorkers(0).enablePrestoWorker(false).build();
    private PulsarCluster pulsarCluster;
    private MetadataStore localMetadataStore;
    private MetadataStore configStore;
    private String metadataServiceUri;
    private MetadataBookieDriver driver;
    private LedgerManager ledgerManager;
    private PulsarClient client;
    private PulsarAdmin admin;

    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        this.pulsarCluster = PulsarCluster.forSpec(this.spec);
        this.pulsarCluster.start();
        this.metadataServiceUri = "zk+null://" + this.pulsarCluster.getZKConnString() + "/ledgers";
        this.localMetadataStore = MetadataStoreFactory.create((String)this.pulsarCluster.getZKConnString(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.configStore = MetadataStoreFactory.create((String)this.pulsarCluster.getCSConnString(), (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.driver = MetadataDrivers.getBookieDriver((URI)URI.create(this.metadataServiceUri));
        this.driver.initialize((ServerConfiguration)new ServerConfiguration().setMetadataServiceUri(this.metadataServiceUri), () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        this.ledgerManager = this.driver.getLedgerManagerFactory().newLedgerManager();
        this.client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        this.admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() throws PulsarClientException {
        this.markCurrentSetupNumberCleaned();
        if (this.client != null) {
            this.client.close();
        }
        if (this.admin != null) {
            this.admin.close();
        }
        try {
            this.ledgerManager.close();
        }
        catch (IOException e) {
            log.warn("Failed to close ledger manager: ", (Throwable)e);
        }
        this.driver.close();
        try {
            this.configStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.localMetadataStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pulsarCluster.stop();
    }

    @Test
    public void testDeleteCluster() throws Exception {
        String[] topics;
        Assert.assertEquals((long)this.getNumOfLedgers(), (long)0L);
        String tenant = "my-tenant";
        String namespace = "my-tenant/my-ns";
        this.admin.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl(new HashSet(), Collections.singleton(this.pulsarCluster.getClusterName())));
        this.admin.namespaces().createNamespace("my-tenant/my-ns");
        for (String topic : topics = new String[]{"topic-1", "topic-2", "my-tenant/my-ns/topic-1"}) {
            String[] subscriptions;
            try (Producer producer = this.client.newProducer(Schema.STRING).topic(topic).create();){
                producer.send((Object)"msg");
            }
            String[] stringArray = subscriptions = new String[]{"sub-1", "sub-2"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String subscription = stringArray[i];
                try (Consumer consumer = this.client.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName(subscription).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
                    Message msg = consumer.receive(5, TimeUnit.SECONDS);
                    consumer.acknowledge(msg);
                    continue;
                }
            }
        }
        String partitionedTopic = "my-tenant/my-ns/par-topic";
        this.admin.topics().createPartitionedTopic("my-tenant/my-ns/par-topic", 3);
        try (Producer producer = this.client.newProducer().topic("my-tenant/my-ns/par-topic").create();){
            producer.send((Object)"msg".getBytes());
            try (Consumer consumer = this.client.newConsumer().topic(new String[]{"my-tenant/my-ns/par-topic"}).subscriptionName("my-sub").subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscribe();){
                Message msg = consumer.receive(5, TimeUnit.SECONDS);
                consumer.acknowledge(msg);
            }
        }
        this.pulsarCluster.getBrokers().forEach(ChaosContainer::stop);
        Assert.assertTrue((this.getNumOfLedgers() > 0L ? 1 : 0) != 0);
        log.info("Before delete, cluster name: {}, num of ledgers: {}", (Object)this.pulsarCluster.getClusterName(), (Object)this.getNumOfLedgers());
        String[] args = new String[]{"-zk", this.pulsarCluster.getZKConnString(), "-cs", this.pulsarCluster.getCSConnString(), "-c", this.pulsarCluster.getClusterName(), "--bookkeeper-metadata-service-uri", this.metadataServiceUri};
        PulsarClusterMetadataTeardown.main((String[])args);
        Assert.assertEquals((long)this.getNumOfLedgers(), (long)0L);
        int zkOpTimeoutMs = 10000;
        List localNodes = (List)this.localMetadataStore.getChildren("/").join();
        for (String node : PulsarClusterMetadataTeardown.localZkNodes) {
            Assert.assertFalse((boolean)localNodes.contains(node));
        }
        List clusterNodes = (List)this.configStore.getChildren("/admin/clusters").join();
        Assert.assertFalse((boolean)clusterNodes.contains(this.pulsarCluster.getClusterName()));
        PulsarClusterMetadataTeardown.main((String[])args);
    }

    private long getNumOfLedgers() {
        AtomicInteger returnCode = new AtomicInteger(0);
        CountDownLatch processDone = new CountDownLatch(1);
        AtomicLong numOfLedgers = new AtomicLong(0L);
        this.ledgerManager.asyncProcessLedgers((ledgerId, cb) -> numOfLedgers.incrementAndGet(), (rc, path, ctx) -> {
            returnCode.set(rc);
            processDone.countDown();
        }, null, 0, -1);
        try {
            processDone.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"asyncProcessLedgers failed", (Throwable)e);
        }
        return numOfLedgers.get();
    }
}

