/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.auth.token;

import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.ProxyContainer;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.containers.ZKContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class PulsarTokenAuthenticationBaseSuite
extends PulsarClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarTokenAuthenticationBaseSuite.class);
    protected String superUserAuthToken;
    protected String proxyAuthToken;
    protected String clientAuthToken;
    protected static final String SUPER_USER_ROLE = "super-user";
    protected static final String PROXY_ROLE = "proxy";
    protected static final String REGULAR_USER_ROLE = "client";
    protected ZKContainer<?> cmdContainer;

    protected abstract void createKeysAndTokens(PulsarContainer<?> var1) throws Exception;

    protected abstract void configureBroker(BrokerContainer var1) throws Exception;

    protected abstract void configureProxy(ProxyContainer var1) throws Exception;

    protected abstract String createClientTokenWithExpiry(long var1, TimeUnit var3) throws Exception;

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setupCluster() throws Exception {
        this.incrementSetupNumber();
        this.cmdContainer = new ZKContainer("cli-setup");
        ((PulsarContainer)((PulsarContainer)this.cmdContainer.withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{"zookeeper"})).withEnv("zkServers", "zookeeper");
        this.cmdContainer.start();
        this.createKeysAndTokens(this.cmdContainer);
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), PulsarTokenAuthenticationBaseSuite.randomName(5)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("-"));
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(2).numProxies(1).clusterName(clusterName).build();
        log.info("Setting up cluster {} with token authentication  and {} bookies, {} brokers", new Object[]{spec.clusterName(), spec.numBookies(), spec.numBrokers()});
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        for (BrokerContainer brokerContainer : this.pulsarCluster.getBrokers()) {
            this.configureBroker(brokerContainer);
            brokerContainer.withEnv("authenticationEnabled", "true");
            brokerContainer.withEnv("authenticationProviders", "org.apache.pulsar.broker.authentication.AuthenticationProviderToken");
            brokerContainer.withEnv("authorizationEnabled", "true");
            brokerContainer.withEnv("superUserRoles", "super-user,proxy");
            brokerContainer.withEnv("brokerClientAuthenticationPlugin", AuthenticationToken.class.getName());
            brokerContainer.withEnv("brokerClientAuthenticationParameters", "token:" + this.superUserAuthToken);
            brokerContainer.withEnv("authenticationRefreshCheckSeconds", "1");
            brokerContainer.withEnv("authenticateOriginalAuthData", "true");
        }
        ProxyContainer proxyContainer = this.pulsarCluster.getProxy();
        this.configureProxy(proxyContainer);
        proxyContainer.withEnv("authenticationEnabled", "true");
        proxyContainer.withEnv("authenticationProviders", "org.apache.pulsar.broker.authentication.AuthenticationProviderToken");
        proxyContainer.withEnv("authorizationEnabled", "true");
        proxyContainer.withEnv("brokerClientAuthenticationPlugin", AuthenticationToken.class.getName());
        proxyContainer.withEnv("brokerClientAuthenticationParameters", "token:" + this.proxyAuthToken);
        proxyContainer.withEnv("forwardAuthorizationCredentials", "true");
        this.pulsarCluster.start();
        log.info("Cluster {} is setup", (Object)spec.clusterName());
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void tearDownCluster() throws Exception {
        super.tearDownCluster();
        this.cmdContainer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishWithTokenAuth() throws Exception {
        String tenant = "token-test-tenant" + PulsarTokenAuthenticationBaseSuite.randomName(4);
        String namespace = tenant + "/ns-1";
        String topic = "persistent://" + namespace + "/topic-1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.superUserAuthToken)).build();
        try {
            try {
                admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.singleton(REGULAR_USER_ROLE), Collections.singleton(this.pulsarCluster.getClusterName())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            admin.namespaces().grantPermissionOnNamespace(namespace, REGULAR_USER_ROLE, EnumSet.allOf(AuthAction.class));
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).authentication(AuthenticationFactory.token((String)this.clientAuthToken)).build();
            try {
                Producer producer = client.newProducer(Schema.STRING).topic(topic).create();
                try {
                    Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{topic}).subscriptionName("my-sub").subscribe();
                    try {
                        int i;
                        int numMessages = 10;
                        for (i = 0; i < 10; ++i) {
                            producer.send((Object)("hello-" + i));
                        }
                        for (i = 0; i < 10; ++i) {
                            Message msg = consumer.receive();
                            Assert.assertEquals((String)((String)msg.getValue()), (String)("hello-" + i));
                            consumer.acknowledge(msg);
                        }
                        PulsarClient clientNoAuth = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
                        try {
                            try {
                                clientNoAuth.newProducer(Schema.STRING).topic(topic).create();
                                Assert.fail((String)"Should have failed to create producer");
                            }
                            catch (PulsarClientException pulsarClientException) {
                                // empty catch block
                            }
                        }
                        finally {
                            if (Collections.singletonList(clientNoAuth).get(0) != null) {
                                clientNoAuth.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(consumer).get(0) != null) {
                            consumer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyRedirectWithTokenAuth() throws Exception {
        String tenant = "token-test-tenant" + PulsarTokenAuthenticationBaseSuite.randomName(4);
        String namespace = tenant + "/ns-1";
        String topic = namespace + "/my-topic-1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.superUserAuthToken)).build();
        try {
            try {
                admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.singleton(REGULAR_USER_ROLE), Collections.singleton(this.pulsarCluster.getClusterName())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            admin.namespaces().grantPermissionOnNamespace(namespace, REGULAR_USER_ROLE, EnumSet.allOf(AuthAction.class));
            admin.topics().createPartitionedTopic(topic, 16);
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).authentication(AuthenticationFactory.token((String)REGULAR_USER_ROLE)).build();
            try {
                client.newProducer().topic(topic).create().close();
                admin.topics().getList(namespace);
                for (int i = 0; i < 10; ++i) {
                    admin.topics().getStats(topic);
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    @DataProvider(name="shouldRefreshToken")
    public static Object[][] shouldRefreshToken() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="shouldRefreshToken")
    public void testExpiringToken(boolean shouldRefreshToken) throws Exception {
        String tenant = "token-test-tenant" + PulsarTokenAuthenticationBaseSuite.randomName(4);
        String namespace = tenant + "/ns-1";
        String topic = "persistent://" + namespace + "/topic-1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.superUserAuthToken)).build();
        try {
            admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.singleton(REGULAR_USER_ROLE), Collections.singleton(this.pulsarCluster.getClusterName())));
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            admin.namespaces().grantPermissionOnNamespace(namespace, REGULAR_USER_ROLE, EnumSet.allOf(AuthAction.class));
            String initialToken = this.createClientTokenWithExpiry(5L, TimeUnit.SECONDS);
            String refreshedToken = this.createClientTokenWithExpiry(30L, TimeUnit.SECONDS);
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).authentication(AuthenticationFactory.token(() -> {
                if (shouldRefreshToken) {
                    try {
                        return refreshedToken;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return initialToken;
            })).build();
            try {
                Producer producer = client.newProducer(Schema.STRING).topic(topic).sendTimeout(3, TimeUnit.SECONDS).create();
                try {
                    producer.send((Object)"hello-1");
                    long lastDisconnectedTimestamp = producer.getLastDisconnectedTimestamp();
                    Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                    if (shouldRefreshToken) {
                        producer.send((Object)"hello-2");
                        long timestamp = producer.getLastDisconnectedTimestamp();
                        Assert.assertEquals((long)timestamp, (long)lastDisconnectedTimestamp);
                    } else {
                        try {
                            producer.send((Object)"hello-2");
                            Assert.fail((String)"Publish should have failed");
                        }
                        catch (PulsarClientException pulsarClientException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiringTokenWithRefreshAndProducerRestart() throws Exception {
        String tenant = "token-expiry-test-tenant" + PulsarTokenAuthenticationBaseSuite.randomName(4);
        String namespace = tenant + "/ns-1";
        String topic = "persistent://" + namespace + "/topic-1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.superUserAuthToken)).build();
        try {
            admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.singleton(REGULAR_USER_ROLE), Collections.singleton(this.pulsarCluster.getClusterName())));
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            admin.namespaces().grantPermissionOnNamespace(namespace, REGULAR_USER_ROLE, EnumSet.allOf(AuthAction.class));
            int TokenExpiryTimeSecs = 2;
            String initialToken = this.createClientTokenWithExpiry(2L, TimeUnit.SECONDS);
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).authentication(AuthenticationFactory.token(() -> {
                try {
                    return this.createClientTokenWithExpiry(2L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    return null;
                }
            })).build();
            try {
                Producer producer1 = client.newProducer(Schema.STRING).topic(topic).sendTimeout(1, TimeUnit.SECONDS).create();
                producer1.send((Object)"hello-1");
                producer1.close();
                Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                Producer producer2 = client.newProducer(Schema.STRING).topic(topic).sendTimeout(1, TimeUnit.SECONDS).create();
                if (Collections.singletonList(producer2).get(0) != null) {
                    producer2.close();
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    @Test
    public void testAuthenticationFailedImmediately() throws PulsarClientException {
        try {
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).authentication(AuthenticationFactory.token((String)"invalid_token")).build();
            try {
                client.newProducer().topic("test_token_topic" + PulsarTokenAuthenticationBaseSuite.randomName(4));
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException authenticationException) {
            // empty catch block
        }
    }
}

