/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.schema;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.apache.avro.reflect.AvroSchema;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JodaTimeTest
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(JodaTimeTest.class);
    private PulsarClient client;
    private PulsarAdmin admin;

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        this.admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();
    }

    @Override
    public void tearDownCluster() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.admin != null) {
            this.admin.close();
        }
        super.tearDownCluster();
    }

    @Test
    public void testJodaTime() throws PulsarAdminException, PulsarClientException {
        String tenant = "public";
        String namespace = "test-namespace-" + JodaTimeTest.randomName(16);
        String topic = "test-joda-time-schema";
        String fqtn = TopicName.get((String)TopicDomain.persistent.value(), (String)"public", (String)namespace, (String)"test-joda-time-schema").toString();
        this.admin.namespaces().createNamespace("public/" + namespace, (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()}));
        JodaSchema forSend = new JodaSchema();
        forSend.setDecimal(new BigDecimal("12.34"));
        forSend.setTimeMicros(System.currentTimeMillis() * 1000L);
        forSend.setTimestampMillis(new DateTime((Object)"2019-03-26T04:39:58.469Z", (Chronology)ISOChronology.getInstanceUTC()));
        forSend.setTimeMillis(LocalTime.now().truncatedTo(ChronoUnit.MILLIS));
        forSend.setTimeMicros(System.currentTimeMillis() * 1000L);
        forSend.setDate(LocalDate.now());
        Producer producer = this.client.newProducer(Schema.AVRO(JodaSchema.class)).topic(fqtn).create();
        Consumer consumer = this.client.newConsumer(Schema.AVRO(JodaSchema.class)).topic(new String[]{fqtn}).subscriptionName("test").subscribe();
        producer.send((Object)forSend);
        JodaSchema received = (JodaSchema)consumer.receive().getValue();
        Assert.assertEquals((Object)received, (Object)forSend);
        producer.close();
        consumer.close();
        log.info("Successfully Joda time logical type message : {}", (Object)received);
    }

    private static class JodaSchema {
        @AvroSchema(value="{\n  \"type\": \"bytes\",\n  \"logicalType\": \"decimal\",\n  \"precision\": 4,\n  \"scale\": 2\n}")
        BigDecimal decimal;
        @AvroSchema(value="{\"type\":\"int\",\"logicalType\":\"date\"}")
        LocalDate date;
        @AvroSchema(value="{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}")
        DateTime timestampMillis;
        @AvroSchema(value="{\"type\":\"int\",\"logicalType\":\"time-millis\"}")
        LocalTime timeMillis;
        @AvroSchema(value="{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}")
        long timestampMicros;
        @AvroSchema(value="{\"type\":\"long\",\"logicalType\":\"time-micros\"}")
        long timeMicros;

        public BigDecimal getDecimal() {
            return this.decimal;
        }

        public LocalDate getDate() {
            return this.date;
        }

        public DateTime getTimestampMillis() {
            return this.timestampMillis;
        }

        public LocalTime getTimeMillis() {
            return this.timeMillis;
        }

        public long getTimestampMicros() {
            return this.timestampMicros;
        }

        public long getTimeMicros() {
            return this.timeMicros;
        }

        public void setDecimal(BigDecimal decimal) {
            this.decimal = decimal;
        }

        public void setDate(LocalDate date) {
            this.date = date;
        }

        public void setTimestampMillis(DateTime timestampMillis) {
            this.timestampMillis = timestampMillis;
        }

        public void setTimeMillis(LocalTime timeMillis) {
            this.timeMillis = timeMillis;
        }

        public void setTimestampMicros(long timestampMicros) {
            this.timestampMicros = timestampMicros;
        }

        public void setTimeMicros(long timeMicros) {
            this.timeMicros = timeMicros;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JodaSchema)) {
                return false;
            }
            JodaSchema other = (JodaSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestampMicros() != other.getTimestampMicros()) {
                return false;
            }
            if (this.getTimeMicros() != other.getTimeMicros()) {
                return false;
            }
            BigDecimal this$decimal = this.getDecimal();
            BigDecimal other$decimal = other.getDecimal();
            if (this$decimal == null ? other$decimal != null : !((Object)this$decimal).equals(other$decimal)) {
                return false;
            }
            LocalDate this$date = this.getDate();
            LocalDate other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            DateTime this$timestampMillis = this.getTimestampMillis();
            DateTime other$timestampMillis = other.getTimestampMillis();
            if (this$timestampMillis == null ? other$timestampMillis != null : !this$timestampMillis.equals(other$timestampMillis)) {
                return false;
            }
            LocalTime this$timeMillis = this.getTimeMillis();
            LocalTime other$timeMillis = other.getTimeMillis();
            return !(this$timeMillis == null ? other$timeMillis != null : !((Object)this$timeMillis).equals(other$timeMillis));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JodaSchema;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestampMicros = this.getTimestampMicros();
            result = result * 59 + (int)($timestampMicros >>> 32 ^ $timestampMicros);
            long $timeMicros = this.getTimeMicros();
            result = result * 59 + (int)($timeMicros >>> 32 ^ $timeMicros);
            BigDecimal $decimal = this.getDecimal();
            result = result * 59 + ($decimal == null ? 43 : ((Object)$decimal).hashCode());
            LocalDate $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            DateTime $timestampMillis = this.getTimestampMillis();
            result = result * 59 + ($timestampMillis == null ? 43 : $timestampMillis.hashCode());
            LocalTime $timeMillis = this.getTimeMillis();
            result = result * 59 + ($timeMillis == null ? 43 : ((Object)$timeMillis).hashCode());
            return result;
        }

        public String toString() {
            return "JodaTimeTest.JodaSchema(decimal=" + this.getDecimal() + ", date=" + this.getDate() + ", timestampMillis=" + this.getTimestampMillis() + ", timeMillis=" + this.getTimeMillis() + ", timestampMicros=" + this.getTimestampMicros() + ", timeMicros=" + this.getTimeMicros() + ")";
        }
    }
}

