/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources.debezium;

import java.io.Closeable;
import java.util.Map;
import org.apache.pulsar.tests.integration.containers.DebeziumMongoDbContainer;
import org.apache.pulsar.tests.integration.io.sources.SourceTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumMongoDbSourceTester
extends SourceTester<DebeziumMongoDbContainer>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DebeziumMongoDbSourceTester.class);
    private static final String NAME = "debezium-mongodb";
    private final String pulsarServiceUrl;
    private DebeziumMongoDbContainer debeziumMongoDbContainer;
    private final PulsarCluster pulsarCluster;

    public DebeziumMongoDbSourceTester(PulsarCluster cluster) {
        super(NAME);
        this.pulsarCluster = cluster;
        this.pulsarServiceUrl = "pulsar://pulsar-proxy:6650";
        this.sourceConfig.put("mongodb.hosts", "rs0/debezium-mongodb-example:27017");
        this.sourceConfig.put("mongodb.name", "dbserver1");
        this.sourceConfig.put("mongodb.user", "debezium");
        this.sourceConfig.put("mongodb.password", "dbz");
        this.sourceConfig.put("mongodb.task.id", "1");
        this.sourceConfig.put("database.whitelist", "inventory");
        this.sourceConfig.put("pulsar.service.url", this.pulsarServiceUrl);
        this.sourceConfig.put("topic.namespace", "debezium/mongodb");
    }

    @Override
    public void setServiceContainer(DebeziumMongoDbContainer container) {
        log.info("start debezium mongodb server container.");
        this.debeziumMongoDbContainer = container;
        this.pulsarCluster.startService("debezium-mongodb-example", this.debeziumMongoDbContainer);
    }

    @Override
    public void prepareSource() throws Exception {
        this.debeziumMongoDbContainer.execCmd("bash", "-c", "/usr/local/bin/init-inventory.sh");
        log.info("debezium mongodb server already contains preconfigured data.");
    }

    @Override
    public void prepareInsertEvent() throws Exception {
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.find()'");
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.insert({ _id : NumberLong(\"110\"),name : \"test-debezium\",description: \"24 inch spare tire\",weight : 22.2,quantity : NumberInt(\"5\")})'");
    }

    @Override
    public void prepareDeleteEvent() throws Exception {
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.find()'");
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.deleteOne({name : \"test-debezium-update\"})'");
    }

    @Override
    public void prepareUpdateEvent() throws Exception {
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.find()'");
        this.debeziumMongoDbContainer.execCmd("/bin/bash", "-c", "mongo -u debezium -p dbz --authenticationDatabase admin localhost:27017/inventory --eval 'db.products.update({_id : 110},{$set:{name:\"test-debezium-update\", description: \"this is update description\"}})'");
    }

    @Override
    public Map<String, String> produceSourceMessages(int numMessages) throws Exception {
        log.info("debezium mongodb server already contains preconfigured data.");
        return null;
    }

    @Override
    public String valueContains() {
        return "dbserver1.inventory.products.Envelope";
    }

    @Override
    public void close() {
        if (this.pulsarCluster != null) {
            PulsarCluster.stopService("debezium-mongodb-example", this.debeziumMongoDbContainer);
        }
    }

    public DebeziumMongoDbContainer getDebeziumMongoDbContainer() {
        return this.debeziumMongoDbContainer;
    }
}

