/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import java.util.Map;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.testcontainers.containers.GenericContainer;
import org.testng.collections.Maps;

public abstract class SinkTester<ServiceContainerT extends GenericContainer> {
    protected final String networkAlias;
    protected final SinkType sinkType;
    protected final String sinkArchive;
    protected final String sinkClassName;
    protected final Map<String, Object> sinkConfig;
    protected ServiceContainerT serviceContainer;

    public SinkTester(String networkAlias, SinkType sinkType) {
        this.networkAlias = networkAlias;
        this.sinkType = sinkType;
        this.sinkArchive = null;
        this.sinkClassName = null;
        this.sinkConfig = Maps.newHashMap();
    }

    public SinkTester(String networkAlias, String sinkArchive, String sinkClassName) {
        this.networkAlias = networkAlias;
        this.sinkType = SinkType.UNDEFINED;
        this.sinkArchive = sinkArchive;
        this.sinkClassName = sinkClassName;
        this.sinkConfig = Maps.newHashMap();
    }

    public Schema<?> getInputTopicSchema() {
        return Schema.STRING;
    }

    protected abstract ServiceContainerT createSinkService(PulsarCluster var1);

    public ServiceContainerT startServiceContainer(PulsarCluster cluster) {
        this.serviceContainer = this.createSinkService(cluster);
        cluster.startService(this.networkAlias, (GenericContainer<?>)this.serviceContainer);
        return this.serviceContainer;
    }

    public void stopServiceContainer(PulsarCluster cluster) {
        if (null != this.serviceContainer) {
            PulsarCluster.stopService(this.networkAlias, this.serviceContainer);
        }
    }

    public SinkType sinkType() {
        return this.sinkType;
    }

    public Map<String, Object> sinkConfig() {
        return this.sinkConfig;
    }

    public abstract void prepareSink() throws Exception;

    public abstract void validateSinkResult(Map<String, String> var1);

    public String getNetworkAlias() {
        return this.networkAlias;
    }

    public SinkType getSinkType() {
        return this.sinkType;
    }

    public String getSinkArchive() {
        return this.sinkArchive;
    }

    public String getSinkClassName() {
        return this.sinkClassName;
    }

    public Map<String, Object> getSinkConfig() {
        return this.sinkConfig;
    }

    public ServiceContainerT getServiceContainer() {
        return this.serviceContainer;
    }

    public static enum SinkType {
        UNDEFINED("undefined"),
        CASSANDRA("cassandra"),
        KAFKA("kafka"),
        JDBC_POSTGRES("jdbc-postgres"),
        HDFS("hdfs"),
        ELASTIC_SEARCH("elastic_search"),
        RABBITMQ("rabbitmq");

        private final String value;

        private SinkType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

