/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import org.apache.pulsar.tests.integration.io.PulsarIOTestBase;
import org.apache.pulsar.tests.integration.io.RabbitMQSinkTester;
import org.apache.pulsar.tests.integration.io.RabbitMQSourceTester;
import org.apache.pulsar.tests.integration.io.sinks.CassandraSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.ElasticSearchSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.HdfsSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.JdbcPostgresSinkTester;
import org.apache.pulsar.tests.integration.io.sinks.KafkaSinkTester;
import org.apache.pulsar.tests.integration.io.sources.KafkaSourceTester;
import org.testng.annotations.Test;

public class PulsarSinksTest
extends PulsarIOTestBase {
    @Test(groups={"sink"})
    public void testKafkaSink() throws Exception {
        String kafkaContainerName = "kafka-" + PulsarSinksTest.randomName(8);
        this.testSink(new KafkaSinkTester(kafkaContainerName), true, new KafkaSourceTester(kafkaContainerName));
    }

    @Test(enabled=false, groups={"sink"})
    public void testCassandraSink() throws Exception {
        this.testSink(CassandraSinkTester.createTester(true), true);
    }

    @Test(enabled=false, groups={"sink"})
    public void testCassandraArchiveSink() throws Exception {
        this.testSink(CassandraSinkTester.createTester(false), false);
    }

    @Test(enabled=false, groups={"sink"})
    public void testHdfsSink() throws Exception {
        this.testSink(new HdfsSinkTester(), false);
    }

    @Test(groups={"sink"})
    public void testJdbcSink() throws Exception {
        this.testSink(new JdbcPostgresSinkTester(), true);
    }

    @Test(enabled=false, groups={"sink"})
    public void testElasticSearchSink() throws Exception {
        this.testSink(new ElasticSearchSinkTester(), true);
    }

    @Test(groups={"sink"})
    public void testRabbitMQSink() throws Exception {
        String containerName = "rabbitmq-" + PulsarSinksTest.randomName(8);
        this.testSink(new RabbitMQSinkTester(containerName), true, new RabbitMQSourceTester(containerName));
    }
}

