/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.pulsar.tests.integration.containers.ElasticSearchContainer;
import org.apache.pulsar.tests.integration.io.sinks.SinkTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.testng.Assert;

public class ElasticSearchSinkTester
extends SinkTester<ElasticSearchContainer> {
    private RestHighLevelClient elasticClient;

    public ElasticSearchSinkTester() {
        super("ElasticSearch", SinkTester.SinkType.ELASTIC_SEARCH);
        this.sinkConfig.put("elasticSearchUrl", "http://ElasticSearch:9200");
        this.sinkConfig.put("indexName", "test-index");
    }

    @Override
    protected ElasticSearchContainer createSinkService(PulsarCluster cluster) {
        return new ElasticSearchContainer(cluster.getClusterName());
    }

    @Override
    public void prepareSink() throws Exception {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", ((ElasticSearchContainer)this.serviceContainer).getMappedPort(9200).intValue(), "http")});
        this.elasticClient = new RestHighLevelClient(builder);
    }

    @Override
    public void validateSinkResult(Map<String, String> kvs) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
        searchRequest.types(new String[]{"doc"});
        try {
            SearchResponse searchResult = this.elasticClient.search(searchRequest, RequestOptions.DEFAULT);
            Assert.assertTrue((searchResult.getHits().getTotalHits().value > 0L ? 1 : 0) != 0, (String)searchResult.toString());
        }
        catch (Exception e) {
            Assert.fail((String)"Encountered exception on validating elastic search results", (Throwable)e);
        }
    }
}

