/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import com.github.dockerjava.api.DockerClient;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.utils.DockerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class ChaosContainer<SelfT extends ChaosContainer<SelfT>>
extends GenericContainer<SelfT> {
    private static final Logger log = LoggerFactory.getLogger(ChaosContainer.class);
    protected final String clusterName;

    protected ChaosContainer(String clusterName, String image) {
        super(image);
        this.clusterName = clusterName;
    }

    protected void configure() {
        super.configure();
        this.addEnv("MALLOC_ARENA_MAX", "1");
    }

    protected void beforeStop() {
        if (null == this.getContainerId()) {
            return;
        }
        DockerUtils.dumpContainerLogToTarget(this.getDockerClient(), this.getContainerId());
    }

    public void stop() {
        this.beforeStop();
        super.stop();
    }

    protected void tailContainerLog() {
        this.withLogConsumer(item -> log.info(item.getUtf8String()));
    }

    public void putFile(String path, byte[] contents) throws Exception {
        String base64contents = Base64.getEncoder().encodeToString(contents);
        String cmd = String.format("echo %s | base64 -d > %s", base64contents, path);
        this.execCmd("bash", "-c", cmd);
    }

    public ContainerExecResult execCmd(String ... commands) throws Exception {
        DockerClient client = this.getDockerClient();
        String dockerId = this.getContainerId();
        return DockerUtils.runCommand(client, dockerId, commands);
    }

    public CompletableFuture<ContainerExecResult> execCmdAsync(String ... commands) throws Exception {
        DockerClient client = this.getDockerClient();
        String dockerId = this.getContainerId();
        return DockerUtils.runCommandAsync(client, dockerId, commands);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChaosContainer)) {
            return false;
        }
        ChaosContainer another = (ChaosContainer)((Object)o);
        return this.clusterName.equals(another.clusterName) && super.equals((Object)another);
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.clusterName);
    }
}

