/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminMultiHostTest
extends TestRetrySupport {
    private final String clusterName = "MultiHostTest-" + UUID.randomUUID();
    private final PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(this.clusterName).numBrokers(3).build();
    private PulsarCluster pulsarCluster = null;

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.incrementSetupNumber();
        this.pulsarCluster = PulsarCluster.forSpec(this.spec);
        this.pulsarCluster.start();
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
            this.pulsarCluster = null;
        }
    }

    @Test
    public void testAdminMultiHost() throws Exception {
        String hosts = this.pulsarCluster.getAllBrokersHttpServiceUrl();
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(hosts).build();
        Assert.assertEquals((int)admin.brokers().getActiveBrokers(this.clusterName).size(), (int)3);
        BrokerContainer one = this.pulsarCluster.getBroker(0);
        one.stop();
        this.waitBrokerDown(admin, 2, 60);
        Assert.assertEquals((int)admin.brokers().getActiveBrokers(this.clusterName).size(), (int)2);
        BrokerContainer two = this.pulsarCluster.getBroker(1);
        two.stop();
        this.waitBrokerDown(admin, 1, 60);
        Assert.assertEquals((int)admin.brokers().getActiveBrokers(this.clusterName).size(), (int)1);
    }

    private void waitBrokerDown(PulsarAdmin admin, int expectBrokers, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            while (admin.brokers().getActiveBrokers(this.clusterName).size() != expectBrokers) {
                admin.brokers().healthcheck();
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            return true;
        });
        new Thread(futureTask).start();
        futureTask.get(timeout, TimeUnit.SECONDS);
    }
}

