/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.auth.admin;

import com.google.common.io.Files;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.containers.ZKContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.utils.DockerUtils;
import org.elasticsearch.common.collect.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.shaded.org.apache.commons.lang.RandomStringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PackagesOpsWithAuthTest
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(PackagesOpsWithAuthTest.class);
    private static final String CLUSTER_PREFIX = "package-auth";
    private static final String PRIVATE_KEY_PATH_INSIDE_CONTAINER = "/tmp/private.key";
    private static final String PUBLIC_KEY_PATH_INSIDE_CONTAINER = "/tmp/public.key";
    private static final String SUPER_USER_ROLE = "super-user";
    private String superUserAuthToken;
    private static final String PROXY_ROLE = "proxy";
    private String proxyAuthToken;
    private static final String REGULAR_USER_ROLE = "client";
    private String clientAuthToken;
    private File publicKeyFile;
    private PulsarCluster pulsarCluster;
    private PulsarContainer cmdContainer;

    @BeforeClass(alwaysRun=true)
    public void setup() throws Exception {
        this.incrementSetupNumber();
        String clusterName = String.format("%s-%s", CLUSTER_PREFIX, RandomStringUtils.randomAlphabetic((int)6));
        String cliContainerName = String.format("%s-%s", "cli", RandomStringUtils.randomAlphabetic((int)6));
        this.cmdContainer = new ZKContainer(cliContainerName);
        this.cmdContainer.withNetwork(Network.newNetwork()).withNetworkAliases(new String[]{"zookeeper"}).withEnv("zkServers", "zookeeper");
        this.cmdContainer.start();
        this.createKeysAndTokens(this.cmdContainer);
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(2).numProxies(1).clusterName(clusterName).brokerEnvs(this.getBrokerSettingsEnvs()).proxyEnvs(this.getProxySettingsEnvs()).brokerMountFiles(Collections.singletonMap(this.publicKeyFile.toString(), PUBLIC_KEY_PATH_INSIDE_CONTAINER)).proxyMountFiles(Collections.singletonMap(this.publicKeyFile.toString(), PUBLIC_KEY_PATH_INSIDE_CONTAINER)).build();
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.cmdContainer != null) {
            this.cmdContainer.stop();
        }
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
        }
    }

    private Map<String, String> getBrokerSettingsEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("enablePackagesManagement", "true");
        envs.put("authenticationEnabled", "true");
        envs.put("authenticationProviders", AuthenticationProviderToken.class.getName());
        envs.put("authorizationEnabled", "true");
        envs.put("superUserRoles", String.format("%s,%s", SUPER_USER_ROLE, PROXY_ROLE));
        envs.put("brokerClientAuthenticationPlugin", AuthenticationToken.class.getName());
        envs.put("brokerClientAuthenticationParameters", String.format("token:%s", this.superUserAuthToken));
        envs.put("authenticationRefreshCheckSeconds", "1");
        envs.put("authenticateOriginalAuthData", "true");
        envs.put("tokenPublicKey", "file:///tmp/public.key");
        return envs;
    }

    private Map<String, String> getProxySettingsEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("authenticationEnabled", "true");
        envs.put("authenticationProviders", AuthenticationProviderToken.class.getName());
        envs.put("authorizationEnabled", "true");
        envs.put("brokerClientAuthenticationPlugin", AuthenticationToken.class.getName());
        envs.put("brokerClientAuthenticationParameters", String.format("token:%s", this.proxyAuthToken));
        envs.put("authenticationRefreshCheckSeconds", "1");
        envs.put("forwardAuthorizationCredentials", "true");
        envs.put("tokenPublicKey", "file:///tmp/public.key");
        return envs;
    }

    protected void createKeysAndTokens(PulsarContainer container) throws Exception {
        container.execCmd("/pulsar/bin/pulsar", "tokens", "create-key-pair", "--output-private-key", PRIVATE_KEY_PATH_INSIDE_CONTAINER, "--output-public-key", PUBLIC_KEY_PATH_INSIDE_CONTAINER);
        byte[] publicKeyBytes = DockerUtils.runCommandWithRawOutput(container.getDockerClient(), container.getContainerId(), "/bin/cat", PUBLIC_KEY_PATH_INSIDE_CONTAINER).getStdout();
        this.publicKeyFile = File.createTempFile("public-", ".key", new File("/tmp"));
        Files.write((byte[])publicKeyBytes, (File)this.publicKeyFile);
        this.clientAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", REGULAR_USER_ROLE).getStdout().trim();
        log.info("Created client token: {}", (Object)this.clientAuthToken);
        this.superUserAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", SUPER_USER_ROLE).getStdout().trim();
        log.info("Created super-user token: {}", (Object)this.superUserAuthToken);
        this.proxyAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--private-key", "file:///tmp/private.key", "--subject", PROXY_ROLE).getStdout().trim();
        log.info("Created proxy token: {}", (Object)this.proxyAuthToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackagesOps() throws Exception {
        PulsarAdmin superUserAdmin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.superUserAuthToken)).build();
        try {
            PulsarAdmin clientAdmin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).authentication(AuthenticationFactory.token((String)this.clientAuthToken)).build();
            try {
                List packagesName;
                try {
                    packagesName = clientAdmin.packages().listPackages("function", "public/default");
                    Assert.fail((String)"list package operation should fail because the client hasn't permission to do");
                }
                catch (PulsarAdminException e) {
                    Assert.assertEquals((int)e.getStatusCode(), (int)401);
                }
                superUserAdmin.namespaces().grantPermissionOnNamespace("public/default", REGULAR_USER_ROLE, Set.of((Object)AuthAction.packages));
                packagesName = clientAdmin.packages().listPackages("function", "public/default");
                Assert.assertEquals((int)packagesName.size(), (int)0);
            }
            finally {
                if (Collections.singletonList(clientAdmin).get(0) != null) {
                    clientAdmin.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(superUserAdmin).get(0) != null) {
                superUserAdmin.close();
            }
        }
    }
}

