/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sinks;

import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.pulsar.tests.integration.io.sinks.ElasticSearchSinkTester;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.awaitility.Awaitility;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;
import org.testng.Assert;

public class OpenSearchSinkTester
extends ElasticSearchSinkTester {
    private RestHighLevelClient elasticClient;

    public OpenSearchSinkTester(boolean schemaEnable) {
        super(schemaEnable);
    }

    @Override
    protected ElasticsearchContainer createSinkService(PulsarCluster cluster) {
        DockerImageName dockerImageName = DockerImageName.parse((String)"opensearchproject/opensearch:1.2.4").asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch");
        return (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(dockerImageName).withEnv("OPENSEARCH_JAVA_OPTS", "-Xms128m -Xmx256m")).withEnv("bootstrap.memory_lock", "true")).withEnv("plugins.security.disabled", "true");
    }

    @Override
    public void prepareSink() throws Exception {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", ((ElasticsearchContainer)this.serviceContainer).getMappedPort(9200).intValue(), "http")});
        this.elasticClient = new RestHighLevelClient(builder);
    }

    @Override
    public void validateSinkResult(Map<String, String> kvs) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"test-index"});
        Awaitility.await().untilAsserted(() -> {
            SearchResponse searchResult = this.elasticClient.search(searchRequest, RequestOptions.DEFAULT);
            Assert.assertTrue((searchResult.getHits().getTotalHits().value > 0L ? 1 : 0) != 0, (String)searchResult.toString());
        });
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.elasticClient != null) {
            this.elasticClient.close();
            this.elasticClient = null;
        }
    }
}

