/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io;

import org.apache.pulsar.tests.integration.functions.PulsarFunctionsTestBase;
import org.apache.pulsar.tests.integration.io.sinks.PulsarIOSinkRunner;
import org.apache.pulsar.tests.integration.io.sinks.SinkTester;
import org.apache.pulsar.tests.integration.io.sources.PulsarIOSourceRunner;
import org.apache.pulsar.tests.integration.io.sources.SourceTester;
import org.testcontainers.containers.GenericContainer;

public abstract class PulsarIOTestBase
extends PulsarFunctionsTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSink(SinkTester tester, boolean builtin) throws Exception {
        tester.startServiceContainer(this.pulsarCluster);
        try {
            PulsarIOSinkRunner runner = new PulsarIOSinkRunner(this.pulsarCluster, this.functionRuntimeType.toString());
            runner.runSinkTester(tester, builtin);
        }
        finally {
            try {
                tester.close();
            }
            finally {
                tester.stopServiceContainer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ServiceContainerT extends GenericContainer> void testSink(SinkTester<ServiceContainerT> sinkTester, boolean builtinSink, SourceTester<ServiceContainerT> sourceTester) throws Exception {
        ServiceContainerT serviceContainer = sinkTester.startServiceContainer(this.pulsarCluster);
        try {
            PulsarIOSinkRunner runner = new PulsarIOSinkRunner(this.pulsarCluster, this.functionRuntimeType.toString());
            runner.runSinkTester(sinkTester, builtinSink);
            if (null != sourceTester) {
                PulsarIOSourceRunner sourceRunner = new PulsarIOSourceRunner(this.pulsarCluster, this.functionRuntimeType.toString());
                sourceTester.setServiceContainer(serviceContainer);
                sourceRunner.testSource(sourceTester);
            }
        }
        finally {
            try {
                sinkTester.close();
            }
            finally {
                sinkTester.stopServiceContainer();
            }
        }
    }
}

