/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions.java;

import java.util.Collections;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.policies.data.FunctionStatusUtil;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.functions.PulsarFunctionsTest;
import org.apache.pulsar.tests.integration.functions.utils.CommandGenerator;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PulsarFunctionsJavaTest
extends PulsarFunctionsTest {
    PulsarFunctionsJavaTest(FunctionRuntimeType functionRuntimeType) {
        super(functionRuntimeType);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaFunctionLocalRun() throws Exception {
        this.testFunctionLocalRun(CommandGenerator.Runtime.JAVA);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaFunctionNegAck() throws Exception {
        this.testFunctionNegAck(CommandGenerator.Runtime.JAVA);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaPublishFunction() throws Exception {
        this.testPublishFunction(CommandGenerator.Runtime.JAVA);
    }

    @Test(groups={"java_function", "function"})
    public void testSerdeFunction() throws Exception {
        this.testCustomSerdeFunction();
    }

    private void testCustomSerdeFunction() throws Exception {
        if (this.functionRuntimeType == FunctionRuntimeType.THREAD) {
            return;
        }
        String inputTopicName = "persistent://public/default/test-serde-java-input-" + PulsarFunctionsJavaTest.randomName(8);
        String outputTopicName = "test-publish-serde-output-" + PulsarFunctionsJavaTest.randomName(8);
        try (PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();){
            admin.topics().createNonPartitionedTopic(inputTopicName);
            admin.topics().createNonPartitionedTopic(outputTopicName);
        }
        String functionName = "test-serde-fn-" + PulsarFunctionsJavaTest.randomName(8);
        this.submitFunction(CommandGenerator.Runtime.JAVA, inputTopicName, outputTopicName, functionName, null, "org.apache.pulsar.functions.api.examples.CustomBaseToBaseFunction", "org.apache.pulsar.functions.api.examples.CustomBaseSerde", Collections.singletonMap("serde-topic", outputTopicName));
        this.getFunctionInfoSuccess(functionName);
        this.getFunctionStatsEmpty(functionName);
        ContainerExecResult result = this.pulsarCluster.getAnyWorker().execCmd("/pulsar/bin/pulsar-admin", "functions", "status", "--tenant", "public", "--namespace", "default", "--name", functionName);
        FunctionStatus functionStatus = FunctionStatusUtil.decode((String)result.getStdout());
        Assert.assertEquals((int)functionStatus.getNumInstances(), (int)1);
        Assert.assertEquals((boolean)((FunctionStatus.FunctionInstanceStatus)functionStatus.getInstances().get(0)).getStatus().isRunning(), (boolean)true);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaExclamationFunction() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.JAVA, false, false, false);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaExclamationTopicPatternFunction() throws Exception {
        this.testExclamationFunction(CommandGenerator.Runtime.JAVA, true, false, false);
    }

    @Test(groups={"java_function", "function"})
    public void testJavaLoggingFunction() throws Exception {
        this.testLoggingFunction(CommandGenerator.Runtime.JAVA);
    }

    @Test(groups={"java_function", "function"})
    public void testInitFunction() throws Exception {
        this.testInitFunction(CommandGenerator.Runtime.JAVA);
    }

    @Test(groups={"java_function", "function"})
    public void testTumblingCountWindowTest() throws Exception {
        String[] EXPECTED_RESULTS = new String[]{"0,1,2,3,4,5,6,7,8,9", "10,11,12,13,14,15,16,17,18,19", "20,21,22,23,24,25,26,27,28,29", "30,31,32,33,34,35,36,37,38,39", "40,41,42,43,44,45,46,47,48,49", "50,51,52,53,54,55,56,57,58,59", "60,61,62,63,64,65,66,67,68,69", "70,71,72,73,74,75,76,77,78,79", "80,81,82,83,84,85,86,87,88,89", "90,91,92,93,94,95,96,97,98,99"};
        this.testWindowFunction("tumbling", EXPECTED_RESULTS);
    }

    @Test(groups={"java_function", "function"})
    public void testSlidingCountWindowTest() throws Exception {
        String[] EXPECTED_RESULTS = new String[]{"0,1,2,3,4", "0,1,2,3,4,5,6,7,8,9", "5,6,7,8,9,10,11,12,13,14", "10,11,12,13,14,15,16,17,18,19", "15,16,17,18,19,20,21,22,23,24", "20,21,22,23,24,25,26,27,28,29", "25,26,27,28,29,30,31,32,33,34", "30,31,32,33,34,35,36,37,38,39", "35,36,37,38,39,40,41,42,43,44", "40,41,42,43,44,45,46,47,48,49", "45,46,47,48,49,50,51,52,53,54", "50,51,52,53,54,55,56,57,58,59", "55,56,57,58,59,60,61,62,63,64", "60,61,62,63,64,65,66,67,68,69", "65,66,67,68,69,70,71,72,73,74", "70,71,72,73,74,75,76,77,78,79", "75,76,77,78,79,80,81,82,83,84", "80,81,82,83,84,85,86,87,88,89", "85,86,87,88,89,90,91,92,93,94", "90,91,92,93,94,95,96,97,98,99"};
        this.testWindowFunction("sliding", EXPECTED_RESULTS);
    }

    @Test(groups={"java_function", "function"})
    public void testMergeFunctionTest() throws Exception {
        this.testMergeFunction();
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectFunction() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.GenericObjectFunction", false, false);
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectRemoveFieldFunction() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.RemoveAvroFieldFunction", true, false);
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectRemoveFieldRecordFunction() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.RemoveAvroFieldRecordFunction", true, false);
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectFunctionKeyValue() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.GenericObjectFunction", false, true);
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectRemoveFieldFunctionKeyValue() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.RemoveAvroFieldFunction", true, true);
    }

    @Test(groups={"java_function", "function"})
    public void testGenericObjectRemoveFieldRecordFunctionKeyValue() throws Exception {
        this.testGenericObjectFunction("org.apache.pulsar.tests.integration.functions.RemoveAvroFieldRecordFunction", true, true);
    }

    @Test(groups={"java_function", "function"})
    public void testRecordFunctionTest() throws Exception {
        this.testRecordFunction();
    }
}

