/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public class StandaloneContainer
extends PulsarContainer<StandaloneContainer> {
    public static final String NAME = "standalone";

    public StandaloneContainer(String clusterName) {
        super(clusterName, NAME, "standalone-cluster", "bin/pulsar", 6650, 8080);
    }

    public StandaloneContainer(String clusterName, String pulsarImageName) {
        super(clusterName, NAME, "standalone-cluster", "bin/pulsar", 6650, 8080, "", pulsarImageName);
    }

    @Override
    protected void configure() {
        super.configure();
        this.setCommand(NAME);
        this.addEnv("PULSAR_MEM", "-Xms128M -Xmx1g -XX:MaxDirectMemorySize=1g");
    }

    @Override
    protected void beforeStart() {
        this.waitStrategy = new HttpWaitStrategy().forPort(8080).forStatusCode(200).forPath("/admin/v2/namespaces/public/default").withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS));
    }

    public String getPlainTextServiceUrl() {
        return "pulsar://" + this.getHost() + ":" + this.getMappedPort(6650);
    }

    public String getHttpServiceUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(8080);
    }
}

