/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.UUID;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.apache.pulsar.tests.integration.utils.DockerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public abstract class PulsarContainer<SelfT extends PulsarContainer<SelfT>>
extends ChaosContainer<SelfT> {
    private static final Logger log = LoggerFactory.getLogger(PulsarContainer.class);
    public static final int INVALID_PORT = -1;
    public static final int ZK_PORT = 2181;
    public static final int CS_PORT = 2184;
    public static final int BOOKIE_PORT = 3181;
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    public static final String DEFAULT_IMAGE_NAME = System.getenv().getOrDefault("PULSAR_TEST_IMAGE_NAME", "apachepulsar/pulsar-test-latest-version:latest");
    public static final String PULSAR_2_5_IMAGE_NAME = "apachepulsar/pulsar:2.5.0";
    public static final String PULSAR_2_4_IMAGE_NAME = "apachepulsar/pulsar:2.4.0";
    public static final String PULSAR_2_3_IMAGE_NAME = "apachepulsar/pulsar:2.3.0";
    public static final String PULSAR_2_2_IMAGE_NAME = "apachepulsar/pulsar:2.2.0";
    public static final String PULSAR_2_1_IMAGE_NAME = "apachepulsar/pulsar:2.1.0";
    public static final String PULSAR_2_0_IMAGE_NAME = "apachepulsar/pulsar:2.0.0";
    public static final boolean PULSAR_CONTAINERS_LEAVE_RUNNING = Boolean.parseBoolean(System.getenv("PULSAR_CONTAINERS_LEAVE_RUNNING"));
    private final String hostname;
    private final String serviceName;
    private final String serviceEntryPoint;
    private final int servicePort;
    private final int httpPort;
    private final String httpPath;

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort) {
        this(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, httpPort, "/metrics");
    }

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort, String httpPath) {
        this(clusterName, hostname, serviceName, serviceEntryPoint, servicePort, httpPort, httpPath, DEFAULT_IMAGE_NAME);
    }

    public PulsarContainer(String clusterName, String hostname, String serviceName, String serviceEntryPoint, int servicePort, int httpPort, String httpPath, String pulsarImageName) {
        super(clusterName, pulsarImageName);
        this.hostname = hostname;
        this.serviceName = serviceName;
        this.serviceEntryPoint = serviceEntryPoint;
        this.servicePort = servicePort;
        this.httpPort = httpPort;
        this.httpPath = httpPath;
        PulsarContainer.configureLeaveContainerRunning(this);
    }

    public static void configureLeaveContainerRunning(GenericContainer<?> container) {
        if (PULSAR_CONTAINERS_LEAVE_RUNNING) {
            container.withReuse(true);
            container.withLabel("pulsarcontainer", "true");
            container.withLabel("pulsarcontainer.random", UUID.randomUUID().toString());
        }
    }

    @Override
    protected void beforeStop() {
        super.beforeStop();
        if (null != this.getContainerId()) {
            DockerUtils.dumpContainerDirToTargetCompressed(this.getDockerClient(), this.getContainerId(), "/var/log/pulsar");
        }
    }

    @Override
    public void stop() {
        if (PULSAR_CONTAINERS_LEAVE_RUNNING) {
            log.warn("Ignoring stop due to PULSAR_CONTAINERS_LEAVE_RUNNING=true.");
            return;
        }
        super.stop();
    }

    public String getContainerName() {
        return this.clusterName + "-" + this.hostname;
    }

    @Override
    protected void configure() {
        super.configure();
        if (this.httpPort > 0) {
            this.addExposedPorts(new int[]{this.httpPort});
        }
        if (this.servicePort > 0) {
            this.addExposedPort(this.servicePort);
        }
    }

    protected void beforeStart() {
    }

    protected void afterStart() {
    }

    public void start() {
        if (this.httpPort > 0 && this.servicePort < 0) {
            this.waitStrategy = new HttpWaitStrategy().forPort(this.httpPort).forStatusCode(200).forPath(this.httpPath).withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS));
        } else if (this.httpPort > 0 || this.servicePort > 0) {
            this.waitStrategy = new HostPortWaitStrategy().withStartupTimeout(Duration.of(300L, ChronoUnit.SECONDS));
        }
        this.withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(this.hostname);
            createContainerCmd.withName(this.getContainerName());
            createContainerCmd.withEntrypoint(new String[]{this.serviceEntryPoint});
        });
        this.beforeStart();
        super.start();
        this.afterStart();
        log.info("[{}] Start pulsar service {} at container {}", new Object[]{this.getContainerName(), this.serviceName, this.getContainerId()});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PulsarContainer)) {
            return false;
        }
        PulsarContainer another = (PulsarContainer)((Object)o);
        return this.getContainerId().equals(another.getContainerId()) && super.equals((Object)another);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.getContainerId());
    }
}

