/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.functions.api.examples.pojo.Tick;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CLITest
extends PulsarTestSuite {
    @Test
    public void testDeprecatedCommands() throws Exception {
        String tenantName = "test-deprecated-commands";
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("--help");
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertFalse((boolean)result.getStdout().contains("Usage: properties "));
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("properties", "create", tenantName, "--allowed-clusters", this.pulsarCluster.getClusterName(), "--admin-roles", "admin");
        Assert.assertTrue((boolean)result.getStderr().contains("deprecated"));
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("properties", "list");
        Assert.assertTrue((boolean)result.getStdout().contains(tenantName));
        result = this.pulsarCluster.runAdminCommandOnAnyBroker("tenants", "list");
        Assert.assertTrue((boolean)result.getStdout().contains(tenantName));
    }

    @Test
    public void testGetTopicListCommand() throws Exception {
        String namespaceLocalName = "list-topics-" + CLITest.randomName(8);
        ContainerExecResult result = this.pulsarCluster.createNamespace(namespaceLocalName);
        String namespace = "public/" + namespaceLocalName;
        Assert.assertEquals((long)0L, (long)result.getExitCode());
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        String persistentTopicName = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)namespace), (String)("get_topics_mode_" + UUID.randomUUID())).toString();
        String nonPersistentTopicName = TopicName.get((String)"non-persistent", (NamespaceName)NamespaceName.get((String)namespace), (String)("get_topics_mode_" + UUID.randomUUID())).toString();
        Producer producer1 = client.newProducer().topic(persistentTopicName).create();
        Producer producer2 = client.newProducer().topic(nonPersistentTopicName).create();
        BrokerContainer container = this.pulsarCluster.getAnyBroker();
        result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "list", namespace);
        Assert.assertTrue((boolean)result.getStdout().contains(persistentTopicName));
        Assert.assertTrue((boolean)result.getStdout().contains(nonPersistentTopicName));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "list", "--topic-domain", "persistent", namespace);
        Assert.assertTrue((boolean)result.getStdout().contains(persistentTopicName));
        Assert.assertFalse((boolean)result.getStdout().contains(nonPersistentTopicName));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "list", "--topic-domain", "non_persistent", namespace);
        Assert.assertFalse((boolean)result.getStdout().contains(persistentTopicName));
        Assert.assertTrue((boolean)result.getStdout().contains(nonPersistentTopicName));
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "topics", "list", "--topic-domain", "none", namespace);
            Assert.fail();
        }
        catch (ContainerExecException containerExecException) {
            // empty catch block
        }
        producer1.close();
        producer2.close();
    }

    @Test
    public void testCreateSubscriptionCommand() throws Exception {
        String topic = "testCreateSubscriptionCommmand";
        String subscriptionPrefix = "subscription-";
        int i = 0;
        for (BrokerContainer container : this.pulsarCluster.getBrokers()) {
            ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "create-subscription", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            result.assertNoOutput();
            ++i;
        }
    }

    @Test
    public void testCreateUpdateSubscriptionWithPropertiesCommand() throws Exception {
        String topic = "testCreateSubscriptionCommmand";
        String subscriptionPrefix = "subscription-";
        int i = 0;
        for (BrokerContainer container : this.pulsarCluster.getBrokers()) {
            ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "create-subscription", "-p", "a=b", "-p", "c=d", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            result.assertNoOutput();
            ContainerExecResult resultUpdate = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "update-subscription-properties", "-p", "a=e", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            resultUpdate.assertNoOutput();
            ContainerExecResult resultGet = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "get-subscription-properties", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            Assert.assertEquals((String)resultGet.getStdout().trim(), (String)"{\"a\":\"e\"}", (String)("unexpected output " + resultGet.getStdout() + " - error " + resultGet.getStderr()));
            ContainerExecResult resultClear = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "update-subscription-properties", "-c", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            resultClear.assertNoOutput();
            ContainerExecResult resultGetAfterClear = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "get-subscription-properties", "persistent://public/default/" + topic, "--subscription", subscriptionPrefix + i);
            Assert.assertEquals((String)resultGetAfterClear.getStdout().trim(), (String)"{}", (String)("unexpected output " + resultGetAfterClear.getStdout() + " - error " + resultGetAfterClear.getStderr()));
            ++i;
        }
    }

    @Test
    public void testTopicTerminationOnTopicsWithoutConnectedConsumers() throws Exception {
        String topicName = "persistent://public/default/test-topic-termination";
        BrokerContainer container = this.pulsarCluster.getAnyBroker();
        container.execCmd("/pulsar/bin/pulsar-admin", "topics", "create", topicName);
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-client", "produce", "-m", "\"test topic termination\"", "-n", "1", topicName);
        Assert.assertTrue((boolean)result.getStdout().contains("1 messages successfully produced"));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "topics", "terminate", topicName);
        Assert.assertTrue((boolean)result.getStdout().contains("Topic successfully terminated at"));
        try {
            this.pulsarCluster.getAnyBroker().execCmd("/pulsar/bin/pulsar-client", "produce", "-m", "\"test topic termination\"", "-n", "1", topicName);
            Assert.fail((String)"Command should have exited with non-zero");
        }
        catch (ContainerExecException e) {
            Assert.assertTrue((boolean)e.getResult().getStdout().contains("Topic was already terminated"));
        }
    }

    @Test
    public void testPropertiesCLI() throws Exception {
        BrokerContainer container = this.pulsarCluster.getAnyBroker();
        String namespace = "public/default";
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "set-property", "-k", "a", "-v", "a", "public/default");
        Assert.assertTrue((boolean)result.getStdout().isEmpty());
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "get-property", "-k", "a", "public/default");
        Assert.assertTrue((boolean)result.getStdout().contains("a"));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "remove-property", "-k", "a", "public/default");
        Assert.assertTrue((boolean)result.getStdout().contains("a"));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "remove-property", "-k", "a", "public/default");
        Assert.assertTrue((boolean)result.getStdout().contains("null"));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "set-properties", "-p", "a=a,b=b,c=c", "public/default");
        Assert.assertTrue((boolean)result.getStdout().isEmpty());
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "get-properties", "public/default");
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        result = container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "clear-properties", "public/default");
        Assert.assertTrue((boolean)result.getStdout().isEmpty());
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "bookies", "set-bookie-rack", "-b", "localhost:8082", "-r", "");
            Assert.fail((String)"Command should have exited with non-zero");
        }
        catch (ContainerExecException e) {
            Assert.assertEquals((String)e.getResult().getStderr(), (String)"rack name is invalid, it should not be null, empty or '/'\n\n");
        }
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "namespaces", "set-schema-autoupdate-strategy", "public/default");
        }
        catch (ContainerExecException e) {
            Assert.assertEquals((String)e.getResult().getStderr(), (String)"Either --compatibility or --disabled must be specified\n\n");
        }
    }

    @Test
    public void testSchemaCLI() throws Exception {
        BrokerContainer container = this.pulsarCluster.getAnyBroker();
        String topicName = "persistent://public/default/test-schema-cli";
        ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-client", "produce", "-m", "\"test topic schema\"", "-n", "1", topicName);
        Assert.assertTrue((boolean)result.getStdout().contains("1 messages successfully produced"));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "schemas", "upload", topicName, "-f", "/pulsar/conf/schema_example.conf");
        result.assertNoOutput();
        result = container.execCmd("/pulsar/bin/pulsar-admin", "schemas", "get", topicName);
        Assert.assertTrue((boolean)result.getStdout().contains("\"type\": \"STRING\""));
        result = container.execCmd("/pulsar/bin/pulsar-admin", "schemas", "delete", topicName);
        result.assertNoOutput();
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "schemas", "get", "persistent://public/default/test-schema-cli");
            Assert.fail((String)"Command should have exited with non-zero");
        }
        catch (ContainerExecException e) {
            Assert.assertTrue((boolean)e.getResult().getStderr().contains("Schema not found"));
        }
        try {
            container.execCmd("/pulsar/bin/pulsar-admin", "schemas", "extract", "--jar", "/pulsar/examples/api-examples.jar", "--type", "xml", "--classname", "org.apache.pulsar.functions.api.examples.pojo.Tick", topicName);
            Assert.fail((String)"Command should have exited with non-zero");
        }
        catch (ContainerExecException e) {
            Assert.assertEquals((String)e.getResult().getStderr(), (String)"Invalid schema type xml. Valid options are: avro, json\n\n");
        }
    }

    @Test
    public void testSetInfiniteRetention() throws Exception {
        String namespace = "get-and-set-retention" + CLITest.randomName(8);
        this.pulsarCluster.createNamespace(namespace);
        String[] setCommand = new String[]{"namespaces", "set-retention", "public/" + namespace, "--size", "-1", "--time", "-1"};
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker(setCommand);
        result.assertNoOutput();
        String[] getCommand = new String[]{"namespaces", "get-retention", "public/" + namespace};
        result = this.pulsarCluster.runAdminCommandOnAnyBroker(getCommand);
        Assert.assertTrue((boolean)result.getStdout().contains("\"retentionTimeInMinutes\" : -1"), (String)result.getStdout());
        Assert.assertTrue((boolean)result.getStdout().contains("\"retentionSizeInMB\" : -1"), (String)result.getStdout());
    }

    @Test
    public void testGrantPermissionsAuthorizationDisabled() throws Exception {
        String namespace = "grant-permissions-" + CLITest.randomName(8);
        ContainerExecResult result = this.pulsarCluster.createNamespace(namespace);
        Assert.assertEquals((long)0L, (long)result.getExitCode());
        String[] grantCommand = new String[]{"namespaces", "grant-permission", "public/" + namespace, "--actions", "produce", "--role", "test-role"};
        try {
            this.pulsarCluster.runAdminCommandOnAnyBroker(grantCommand);
        }
        catch (ContainerExecException cee) {
            result = cee.getResult();
            Assert.assertTrue((boolean)result.getStderr().contains("HTTP 501 Not Implemented"), (String)result.getStderr());
        }
    }

    @Test
    public void testJarPojoSchemaUploadAvro() throws Exception {
        ContainerExecResult containerExecResult = this.pulsarCluster.runAdminCommandOnAnyBroker("schemas", "extract", "--jar", "/pulsar/examples/api-examples.jar", "--type", "avro", "--classname", "org.apache.pulsar.functions.api.examples.pojo.Tick", "persistent://public/default/pojo-avro");
        Assert.assertEquals((long)containerExecResult.getExitCode(), (long)0L);
        this.testPublishAndConsume("persistent://public/default/pojo-avro", "avro", (Schema<Tick>)Schema.AVRO(Tick.class));
    }

    @Test
    public void testJarPojoSchemaUploadJson() throws Exception {
        ContainerExecResult containerExecResult = this.pulsarCluster.runAdminCommandOnAnyBroker("schemas", "extract", "--jar", "/pulsar/examples/api-examples.jar", "--type", "json", "--classname", "org.apache.pulsar.functions.api.examples.pojo.Tick", "persistent://public/default/pojo-json");
        Assert.assertEquals((long)containerExecResult.getExitCode(), (long)0L);
        this.testPublishAndConsume("persistent://public/default/pojo-json", "json", (Schema<Tick>)Schema.JSON(Tick.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPublishAndConsume(String topic, String sub, Schema<Tick> type) throws PulsarClientException {
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        try {
            Producer producer = client.newProducer(type).topic(topic + "-message").create();
            try {
                Consumer consumer = client.newConsumer(type).topic(new String[]{topic + "-message"}).subscriptionName(sub).subscribe();
                try {
                    int i;
                    int numOfMessages = 10;
                    for (i = 1; i < 10; ++i) {
                        producer.send((Object)new Tick((long)i, "Stock_" + i, (double)(100 + i), (double)(110 + i)));
                    }
                    for (i = 1; i < 10; ++i) {
                        Tick expected = new Tick((long)i, "Stock_" + i, (double)(100 + i), (double)(110 + i));
                        Message receive = consumer.receive(5, TimeUnit.SECONDS);
                        Assert.assertEquals((Object)receive.getValue(), (Object)expected);
                    }
                }
                finally {
                    if (Collections.singletonList(consumer).get(0) != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testListNonPersistentTopicsCmd() throws Exception {
        String persistentTopic = "test-list-non-persistent-topic";
        ContainerExecResult result = this.pulsarCluster.runAdminCommandOnAnyBroker("topics", "create", persistentTopic);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        HttpGet get = new HttpGet(this.pulsarCluster.getHttpServiceUrl() + "/admin/v2/non-persistent/public/default");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            Assert.assertFalse((boolean)EntityUtils.toString((HttpEntity)response.getEntity()).contains(persistentTopic));
        }
    }

    @Test
    public void testGenerateDocForModule() throws Exception {
        String[] moduleNames = new String[]{"clusters", "tenants", "brokers", "broker-stats", "namespaces", "topics", "schemas", "bookies", "functions", "ns-isolation-policy", "resource-quotas", "functions", "sources", "sinks"};
        BrokerContainer container = this.pulsarCluster.getAnyBroker();
        for (int i = 0; i < moduleNames.length; ++i) {
            ContainerExecResult result = container.execCmd("/pulsar/bin/pulsar-admin", "documents", "generate", moduleNames[i]);
            Assert.assertTrue((boolean)result.getStdout().contains("------------\n\n# " + moduleNames[i]));
        }
    }
}

