/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.transaction;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionTestBase
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(TransactionTestBase.class);

    @Override
    protected void beforeStartCluster() throws Exception {
        super.beforeStartCluster();
        for (BrokerContainer brokerContainer : this.pulsarCluster.getBrokers()) {
            brokerContainer.withEnv("transactionCoordinatorEnabled", "true");
            brokerContainer.withEnv("transactionMetadataStoreProviderClassName", "org.apache.pulsar.transaction.coordinator.impl.InMemTransactionMetadataStoreProvider");
            brokerContainer.withEnv("transactionBufferProviderClassName", "org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferProvider");
            brokerContainer.withEnv("acknowledgmentAtBatchIndexLevelEnabled", "true");
        }
    }

    private void transactionCoordinatorMetadataInitialize() throws Exception {
        BrokerContainer brokerContainer = this.pulsarCluster.getBrokers().iterator().next();
        ContainerExecResult result = brokerContainer.execCmd("/pulsar/bin/pulsar", "initialize-transaction-coordinator-metadata", "-cs", "zookeeper", "-c", this.pulsarCluster.getClusterName());
    }

    @Override
    public void setupCluster() throws Exception {
        super.setupCluster();
        this.transactionCoordinatorMetadataInitialize();
    }

    public void prepareTransferData(Producer<TransferOperation> transferProducer, int messageCnt) {
        for (int i = 0; i < messageCnt; ++i) {
            TransferOperation transferOperation = new TransferOperation();
            transferOperation.setFromAccount("alice");
            transferOperation.setToAccount("Bob");
            transferOperation.setAmount(100 * i);
            CompletableFuture completableFuture = transferProducer.newMessage().value((Object)transferOperation).sendAsync();
        }
        log.info("transfer messages produced");
    }

    public BalanceUpdate getBalanceUpdate(TransferOperation transferOperation, boolean isFromAccount) {
        BalanceUpdate balanceUpdate = new BalanceUpdate();
        balanceUpdate.setAccount(transferOperation.getFromAccount());
        if (isFromAccount) {
            balanceUpdate.setAmount(-transferOperation.getAmount());
        } else {
            balanceUpdate.setAmount(transferOperation.getAmount());
        }
        return balanceUpdate;
    }

    public static class TransferOperation {
        private String fromAccount;
        private String toAccount;
        private int amount;

        public String getFromAccount() {
            return this.fromAccount;
        }

        public String getToAccount() {
            return this.toAccount;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setFromAccount(String fromAccount) {
            this.fromAccount = fromAccount;
        }

        public void setToAccount(String toAccount) {
            this.toAccount = toAccount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferOperation)) {
                return false;
            }
            TransferOperation other = (TransferOperation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            String this$fromAccount = this.getFromAccount();
            String other$fromAccount = other.getFromAccount();
            if (this$fromAccount == null ? other$fromAccount != null : !this$fromAccount.equals(other$fromAccount)) {
                return false;
            }
            String this$toAccount = this.getToAccount();
            String other$toAccount = other.getToAccount();
            return !(this$toAccount == null ? other$toAccount != null : !this$toAccount.equals(other$toAccount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransferOperation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            String $fromAccount = this.getFromAccount();
            result = result * 59 + ($fromAccount == null ? 43 : $fromAccount.hashCode());
            String $toAccount = this.getToAccount();
            result = result * 59 + ($toAccount == null ? 43 : $toAccount.hashCode());
            return result;
        }

        public String toString() {
            return "TransactionTestBase.TransferOperation(fromAccount=" + this.getFromAccount() + ", toAccount=" + this.getToAccount() + ", amount=" + this.getAmount() + ")";
        }
    }

    public static class BalanceUpdate {
        private String account;
        private int amount;

        public String getAccount() {
            return this.account;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BalanceUpdate)) {
                return false;
            }
            BalanceUpdate other = (BalanceUpdate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            return !(this$account == null ? other$account != null : !this$account.equals(other$account));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BalanceUpdate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            return result;
        }

        public String toString() {
            return "TransactionTestBase.BalanceUpdate(account=" + this.getAccount() + ", amount=" + this.getAmount() + ")";
        }
    }
}

