/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.python;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PythonSchemaTest
extends PulsarTestSuite {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceUrls")
    public void testJavaPublishPythonConsume(Supplier<String> serviceUrl) throws Exception {
        String nsName = PythonSchemaTest.generateNamespaceName();
        this.pulsarCluster.createNamespace(nsName);
        String topicName = PythonSchemaTest.generateTopicName(nsName, "testJavaPublishPythonConsume", true);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            client.newConsumer(Schema.JSON(Example1.class)).topic(new String[]{topicName}).subscriptionName("my-subscription").subscribe().close();
            Producer producer = client.newProducer(Schema.JSON(Example1.class)).topic(topicName).create();
            try {
                Example1 e1 = new Example1();
                e1.setX(1);
                e1.setY(2L);
                producer.send((Object)e1);
                ContainerExecResult res = this.pulsarCluster.getAnyBroker().execCmd("/pulsar/examples/python-examples/consumer_schema.py", "pulsar://localhost:6650", topicName);
                Assert.assertEquals((long)res.getExitCode(), (long)0L);
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceUrls")
    public void testPythonPublishJavaConsume(Supplier<String> serviceUrl) throws Exception {
        String nsName = PythonSchemaTest.generateNamespaceName();
        this.pulsarCluster.createNamespace(nsName);
        String topicName = PythonSchemaTest.generateTopicName(nsName, "testPythonPublishJavaConsume", true);
        PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
        try {
            Consumer consumer = client.newConsumer(Schema.AVRO(Example2.class)).topic(new String[]{topicName}).subscriptionName("test-sub").subscribe();
            try {
                ContainerExecResult res = this.pulsarCluster.getAnyBroker().execCmd("/pulsar/examples/python-examples/producer_schema.py", "pulsar://localhost:6650", topicName);
                Assert.assertEquals((long)res.getExitCode(), (long)0L);
                Message msg = consumer.receive();
                Example2 e2 = (Example2)msg.getValue();
                Assert.assertEquals((String)e2.a, (String)"Hello");
                Assert.assertEquals((int)e2.b, (int)1);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    static class Example1 {
        private Integer x;
        private Long y;

        public Integer getX() {
            return this.x;
        }

        public Long getY() {
            return this.y;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public void setY(Long y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Example1)) {
                return false;
            }
            Example1 other = (Example1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$x = this.getX();
            Integer other$x = other.getX();
            if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                return false;
            }
            Long this$y = this.getY();
            Long other$y = other.getY();
            return !(this$y == null ? other$y != null : !((Object)this$y).equals(other$y));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Example1;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            Long $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            return result;
        }

        public String toString() {
            return "PythonSchemaTest.Example1(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    static class Example2 {
        private String a;
        private int b;

        public String getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public void setA(String a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Example2)) {
                return false;
            }
            Example2 other = (Example2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getB() != other.getB()) {
                return false;
            }
            String this$a = this.getA();
            String other$a = other.getA();
            return !(this$a == null ? other$a != null : !this$a.equals(other$a));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Example2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getB();
            String $a = this.getA();
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            return result;
        }

        public String toString() {
            return "PythonSchemaTest.Example2(a=" + this.getA() + ", b=" + this.getB() + ")";
        }
    }
}

