/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.io.sources.debezium;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.tests.integration.containers.DebeziumOracleDbContainer;
import org.apache.pulsar.tests.integration.io.PulsarIOTestBase;
import org.apache.pulsar.tests.integration.io.sources.debezium.DebeziumOracleDbSourceTester;
import org.apache.pulsar.tests.integration.io.sources.debezium.PulsarIODebeziumSourceRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testng.annotations.Test;

public class PulsarDebeziumOracleSourceTest
extends PulsarIOTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarDebeziumOracleSourceTest.class);
    protected final AtomicInteger testId = new AtomicInteger(0);

    @Test(groups={"source"}, timeOut=1800000L)
    public void testDebeziumOracleDbSource() throws Exception {
        this.testDebeziumOracleDbConnect("org.apache.kafka.connect.json.JsonConverter", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDebeziumOracleDbConnect(String converterClassName, boolean jsonWithEnvelope) throws Exception {
        String tenant = "public";
        String namespace = "default";
        String outputTopicName = "debe-output-topic-name-" + this.testId.getAndIncrement();
        String consumeTopicName = "debezium/oracle/XE.INV.CUSTOMERS";
        String sourceName = "test-source-debezium-oracle-" + (Object)((Object)this.functionRuntimeType) + "-" + PulsarDebeziumOracleSourceTest.randomName(8);
        boolean numMessages = true;
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarCluster.getPlainTextServiceUrl()).build();
        try {
            PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getHttpServiceUrl()).build();
            try {
                this.initNamespace(admin);
                admin.topics().createNonPartitionedTopic("debezium/oracle/XE.INV.CUSTOMERS");
                admin.topics().createNonPartitionedTopic(outputTopicName);
                DebeziumOracleDbSourceTester sourceTester = new DebeziumOracleDbSourceTester(this.pulsarCluster);
                try {
                    sourceTester.getSourceConfig().put("json-with-envelope", jsonWithEnvelope);
                    DebeziumOracleDbContainer debeziumOracleDbContainer = new DebeziumOracleDbContainer(this.pulsarCluster.getClusterName());
                    sourceTester.setServiceContainer(debeziumOracleDbContainer);
                    PulsarIODebeziumSourceRunner runner = new PulsarIODebeziumSourceRunner(this.pulsarCluster, this.functionRuntimeType.toString(), converterClassName, "public", "default", sourceName, outputTopicName, 1, jsonWithEnvelope, "debezium/oracle/XE.INV.CUSTOMERS", client);
                    runner.testSource(sourceTester);
                }
                finally {
                    if (Collections.singletonList(sourceTester).get(0) != null) {
                        sourceTester.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(admin).get(0) != null) {
                    admin.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    protected void initNamespace(PulsarAdmin admin) {
        log.info("[initNamespace] start.");
        try {
            admin.tenants().createTenant("debezium", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{this.pulsarCluster.getClusterName()})));
            String[] namespaces = new String[]{"debezium/oracle"};
            Policies policies = new Policies();
            policies.retention_policies = new RetentionPolicies(-1, 50);
            for (String ns : namespaces) {
                admin.namespaces().createNamespace(ns, policies);
            }
        }
        catch (Exception e) {
            log.info("[initNamespace] msg: {}", (Object)e.getMessage());
        }
        log.info("[initNamespace] finish.");
    }
}

