/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class CassandraContainer<SelfT extends ChaosContainer<SelfT>>
extends ChaosContainer<SelfT> {
    private static final Logger log = LoggerFactory.getLogger(CassandraContainer.class);
    public static final String NAME = "cassandra";
    public static final int PORT = 9042;

    public CassandraContainer(String clusterName) {
        super(clusterName, "cassandra:3");
    }

    @Override
    protected void configure() {
        super.configure();
        ((ChaosContainer)((ChaosContainer)((ChaosContainer)this.withNetworkAliases(new String[]{NAME})).withExposedPorts(new Integer[]{9042})).withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(NAME);
            createContainerCmd.withName(this.clusterName + "-" + NAME);
        })).waitingFor((WaitStrategy)new HostPortWaitStrategy());
    }

    public int getCassandraPort() {
        return this.getMappedPort(9042);
    }
}

