/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.admin;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.tests.integration.messaging.MessagingBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdminTest
extends MessagingBase {
    private static final Logger log = LoggerFactory.getLogger(AdminTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="ServiceAndAdminUrls")
    public void testUnderReplicatedState(Supplier<String> serviceUrl, Supplier<String> adminUrl) throws Exception {
        String topicName = this.getNonPartitionedTopic("replicated-state", true);
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(adminUrl.get()).build();
        try {
            PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl.get()).build();
            try {
                Producer producer = client.newProducer(Schema.STRING).topic(topicName).enableBatching(false).create();
                try {
                    for (int i = 0; i < 10; ++i) {
                        MessageId messageId = producer.newMessage().value((Object)(producer.getProducerName() + "-" + i)).send();
                        Assert.assertNotNull((Object)messageId);
                    }
                    log.info("Successfully to publish 10 messages to {}", (Object)topicName);
                    PersistentTopicInternalStats stats = admin.topics().getInternalStats(topicName);
                    Assert.assertTrue((stats.ledgers.size() > 0 ? 1 : 0) != 0);
                    for (ManagedLedgerInternalStats.LedgerInfo ledger : stats.ledgers) {
                        Assert.assertFalse((boolean)ledger.underReplicated);
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }
}

