/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.messaging;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.tests.integration.topologies.PulsarGeoClusterTestBase;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GeoReplicationTest
extends PulsarGeoClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(GeoReplicationTest.class);

    @BeforeClass(alwaysRun=true)
    public final void setupBeforeClass() throws Exception {
        this.setup();
    }

    @AfterClass(alwaysRun=true)
    public final void tearDownAfterClass() throws Exception {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L, dataProvider="TopicDomain")
    public void testTopicReplication(String domain) throws Exception {
        String cluster1 = this.getGeoCluster().getClusters()[0].getClusterName();
        String cluster2 = this.getGeoCluster().getClusters()[1].getClusterName();
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.getGeoCluster().getClusters()[0].getHttpServiceUrl()).requestTimeout(30, TimeUnit.SECONDS).build();
        try {
            String topic = domain + "://public/default/testTopicReplication-" + UUID.randomUUID();
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
                try {
                    admin.topics().createPartitionedTopic(topic, 10);
                }
                catch (Exception e) {
                    log.error("Failed to create partitioned topic {}.", (Object)topic, (Object)e);
                    Assert.fail((String)("Failed to create partitioned topic " + topic));
                }
                Assert.assertEquals((int)admin.topics().getPartitionedTopicMetadata((String)topic).partitions, (int)10);
            });
            log.info("Test geo-replication produce and consume for topic {}.", (Object)topic);
            PulsarClient client1 = PulsarClient.builder().serviceUrl(this.getGeoCluster().getClusters()[0].getPlainTextServiceUrl()).build();
            try {
                PulsarClient client2 = PulsarClient.builder().serviceUrl(this.getGeoCluster().getClusters()[1].getPlainTextServiceUrl()).build();
                try {
                    Producer p = client1.newProducer().topic(topic).create();
                    try {
                        log.info("Successfully create producer in cluster {} for topic {}.", (Object)cluster1, (Object)topic);
                        Consumer c = client2.newConsumer().topic(new String[]{topic}).subscriptionName("geo-sub").subscribe();
                        try {
                            int i;
                            log.info("Successfully create consumer in cluster {} for topic {}.", (Object)cluster2, (Object)topic);
                            for (i = 0; i < 10; ++i) {
                                p.send((Object)String.format("Message [%d]", i).getBytes(StandardCharsets.UTF_8));
                            }
                            log.info("Successfully produce message to cluster {} for topic {}.", (Object)cluster1, (Object)topic);
                            for (i = 0; i < 10; ++i) {
                                Message message = c.receive(10, TimeUnit.SECONDS);
                                Assert.assertNotNull((Object)message);
                            }
                            log.info("Successfully consume message from cluster {} for topic {}.", (Object)cluster2, (Object)topic);
                        }
                        finally {
                            if (Collections.singletonList(c).get(0) != null) {
                                c.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(p).get(0) != null) {
                            p.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(client2).get(0) != null) {
                        client2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client1).get(0) != null) {
                    client1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }
}

