/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.utils.DockerUtils;

public class PrestoWorkerContainer
extends PulsarContainer<PrestoWorkerContainer> {
    public static final String NAME = "presto-worker";
    public static final int PRESTO_HTTP_PORT = 8081;

    public PrestoWorkerContainer(String clusterName, String hostname) {
        super(clusterName, hostname, hostname, "bin/run-presto-worker.sh", -1, 8081, "/v1/info/state");
        this.tailContainerLog();
    }

    @Override
    protected void afterStart() {
        DockerUtils.runCommandAsyncWithLogging(this.dockerClient, this.getContainerId(), "tail", "-f", "/pulsar/lib/presto/var/log/launcher.log");
        DockerUtils.runCommandAsyncWithLogging(this.dockerClient, this.getContainerId(), "tail", "-f", "/var/log/pulsar/presto_worker.log");
        DockerUtils.runCommandAsyncWithLogging(this.dockerClient, this.getContainerId(), "tail", "-f", "/pulsar/lib/presto/var/log/server.log");
    }

    @Override
    protected void beforeStop() {
        super.beforeStop();
        if (null != this.getContainerId()) {
            DockerUtils.dumpContainerDirToTargetCompressed(this.getDockerClient(), this.getContainerId(), "/pulsar/lib/presto/var/log");
        }
    }

    public String getUrl() {
        return String.format("%s:%s", this.getContainerIpAddress(), this.getMappedPort(8081));
    }
}

