/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import java.util.Optional;
import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ElasticSearchContainer
extends ChaosContainer<ElasticSearchContainer> {
    public static final String NAME = "ElasticSearch";
    static final Integer[] PORTS = new Integer[]{9200, 9300};
    public static final String IMAGE_NAME = Optional.ofNullable(System.getenv("ELASTICSEARCH_IMAGE")).orElse("docker.elastic.co/elasticsearch/elasticsearch:7.15.0");

    public ElasticSearchContainer(String clusterName) {
        super(clusterName, IMAGE_NAME);
    }

    @Override
    protected void configure() {
        super.configure();
        ((ElasticSearchContainer)((ElasticSearchContainer)((ElasticSearchContainer)((ElasticSearchContainer)((ElasticSearchContainer)this.withNetworkAliases(new String[]{NAME})).withExposedPorts(PORTS)).withEnv("discovery.type", "single-node")).withEnv("ES_JAVA_OPTS", "-Xms512m -Xmx1500m")).withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(NAME);
            createContainerCmd.withName(this.clusterName + "-" + NAME);
        })).waitingFor((WaitStrategy)new HostPortWaitStrategy());
    }
}

