/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import org.apache.pulsar.tests.integration.containers.WorkerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.functions.PulsarFunctionsTestBase;
import org.apache.pulsar.tests.integration.functions.utils.UploadDownloadCommandGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class FunctionsCLITest
extends PulsarFunctionsTestBase {
    private static final Logger log = LoggerFactory.getLogger(FunctionsCLITest.class);

    public String uploadFunction() throws Exception {
        String bkPkgPath = String.format("%s/%s/%s", "tenant-" + FunctionsCLITest.randomName(8), "ns-" + FunctionsCLITest.randomName(8), "fn-" + FunctionsCLITest.randomName(8));
        UploadDownloadCommandGenerator generator = UploadDownloadCommandGenerator.createUploader("/pulsar/bin/pulsar-admin", bkPkgPath);
        String actualCommand = generator.generateCommand();
        log.info(actualCommand);
        String[] commands = new String[]{"sh", "-c", actualCommand};
        ContainerExecResult output = this.pulsarCluster.getAnyWorker().execCmd(commands);
        Assert.assertEquals((long)0L, (long)output.getExitCode());
        Assert.assertTrue((boolean)output.getStdout().contains("Uploaded successfully"));
        return bkPkgPath;
    }

    public void testUploadDownload() throws Exception {
        String bkPkgPath = this.uploadFunction();
        String localPkgFile = "/tmp/checkdownload-" + FunctionsCLITest.randomName(16);
        UploadDownloadCommandGenerator generator = UploadDownloadCommandGenerator.createDownloader(localPkgFile, bkPkgPath);
        String actualCommand = generator.generateCommand();
        log.info(actualCommand);
        String[] commands = new String[]{"sh", "-c", actualCommand};
        WorkerContainer container = this.pulsarCluster.getAnyWorker();
        ContainerExecResult output = container.execCmd(commands);
        Assert.assertEquals((long)0L, (long)output.getExitCode());
        Assert.assertTrue((boolean)output.getStdout().contains("Downloaded successfully"));
        String[] diffCommand = new String[]{"diff", "/pulsar/bin/pulsar-admin", localPkgFile};
        output = container.execCmd(diffCommand);
        Assert.assertEquals((long)0L, (long)output.getExitCode());
        output.assertNoOutput();
    }
}

