/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.testcontainers.shaded.org.apache.commons.lang.RandomStringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileSystemPackagesCliTest
extends TestRetrySupport {
    private static final String clusterNamePrefix = "file-system-packages-service";
    private PulsarCluster pulsarCluster;

    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(String.format("%s-%s", clusterNamePrefix, RandomStringUtils.randomAlphabetic((int)6))).brokerEnvs(this.getPackagesManagementServiceEnvs()).build();
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
            this.pulsarCluster = null;
        }
    }

    private Map<String, String> getPackagesManagementServiceEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("enablePackagesManagement", "true");
        envs.put("packagesManagementStorageProvider", "org.apache.pulsar.packages.management.storage.filesystem.FileSystemPackagesStorageProvider");
        return envs;
    }

    @Test(timeOut=480000L)
    public void testPackagesOperationsWithUploadingPackagesUsingFileSystemStorageProvider() throws Exception {
        BrokerContainer container = this.pulsarCluster.getBroker(0);
        String testPackageName = "function://public/default/test@v1";
        String[] uploadCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "upload", "--description", "a test package", "--path", "/pulsar/bin/pulsar-admin", testPackageName};
        ContainerExecResult result = container.execCmd(uploadCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        String downloadFile = "tmp-file-" + RandomStringUtils.randomAlphabetic((int)8);
        String[] downloadCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "download", "--path", downloadFile, testPackageName};
        result = container.execCmd(downloadCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        String[] diffCmd = new String[]{"diff", "/pulsar/bin/pulsar-admin", downloadFile};
        result = container.execCmd(diffCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        String[] getMetadataCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "get-metadata", testPackageName};
        result = container.execCmd(getMetadataCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("a test package"));
        String[] listCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "list", "--type", "function", "public/default"};
        result = container.execCmd(listCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("test"));
        String[] listVersionsCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "list-versions", "function://public/default/test"};
        result = container.execCmd(listVersionsCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("v1"));
        String contact = "test@apache.org";
        String[] updateMetadataCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "update-metadata", "--description", "a test package", "--contact", contact, "-PpropertyA=A", testPackageName};
        result = container.execCmd(updateMetadataCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = container.execCmd(getMetadataCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("a test package"));
        Assert.assertTrue((boolean)result.getStdout().contains(contact));
        Assert.assertTrue((boolean)result.getStdout().contains("propertyA"));
        String[] deleteCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "delete", testPackageName};
        result = container.execCmd(deleteCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = container.execCmd(listVersionsCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result.assertNoStdout();
    }
}

