/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.auth.token;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.tests.integration.auth.token.PulsarTokenAuthenticationBaseSuite;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.containers.ProxyContainer;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthWithSymmetricKeys
extends PulsarTokenAuthenticationBaseSuite {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthWithSymmetricKeys.class);
    private String secretKey;

    protected void createKeysAndTokens(PulsarContainer container) throws Exception {
        this.secretKey = container.execCmd("/pulsar/bin/pulsar", "tokens", "create-secret-key", "--base64").getStdout();
        log.info("Created secret key: {}", (Object)this.secretKey);
        this.clientAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--secret-key", "data:;base64," + this.secretKey, "--subject", "client").getStdout().trim();
        log.info("Created client token: {}", (Object)this.clientAuthToken);
        this.superUserAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--secret-key", "data:;base64," + this.secretKey, "--subject", "super-user").getStdout().trim();
        log.info("Created super-user token: {}", (Object)this.superUserAuthToken);
        this.proxyAuthToken = container.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--secret-key", "data:;base64," + this.secretKey, "--subject", "proxy").getStdout().trim();
        log.info("Created proxy token: {}", (Object)this.proxyAuthToken);
    }

    @Override
    protected void configureBroker(BrokerContainer brokerContainer) throws Exception {
        brokerContainer.withEnv("tokenSecretKey", "data:;base64," + this.secretKey);
    }

    @Override
    protected void configureProxy(ProxyContainer proxyContainer) throws Exception {
        proxyContainer.withEnv("tokenSecretKey", "data:;base64," + this.secretKey);
    }

    @Override
    protected String createClientTokenWithExpiry(long expiryTime, TimeUnit unit) throws Exception {
        return this.cmdContainer.execCmd("/pulsar/bin/pulsar", "tokens", "create", "--secret-key", "data:;base64," + this.secretKey, "--subject", "client", "--expiry-time", unit.toSeconds(expiryTime) + "s").getStdout().trim();
    }
}

