/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.topologies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.tests.integration.containers.PulsarContainer;
import org.apache.pulsar.tests.integration.topologies.FunctionRuntimeType;
import org.testcontainers.containers.GenericContainer;

public class PulsarClusterSpec {
    String clusterName;
    int numBookies;
    int numBrokers;
    int numProxies;
    int numFunctionWorkers;
    boolean enablePrestoWorker;
    boolean queryLastMessage;
    FunctionRuntimeType functionRuntimeType;
    Map<String, GenericContainer<?>> externalServices = Collections.EMPTY_MAP;
    boolean enableContainerLog;
    Map<String, String> classPathVolumeMounts;
    String pulsarTestImage;
    Map<String, String> proxyEnvs;
    Map<String, String> brokerEnvs;
    Map<String, String> proxyMountFiles;
    Map<String, String> brokerMountFiles;
    int maxMessageSize;

    private static int $default$numBookies() {
        return 2;
    }

    private static int $default$numBrokers() {
        return 2;
    }

    private static int $default$numProxies() {
        return 1;
    }

    private static int $default$numFunctionWorkers() {
        return 0;
    }

    private static boolean $default$enablePrestoWorker() {
        return false;
    }

    private static boolean $default$queryLastMessage() {
        return false;
    }

    private static FunctionRuntimeType $default$functionRuntimeType() {
        return FunctionRuntimeType.PROCESS;
    }

    private static boolean $default$enableContainerLog() {
        return false;
    }

    private static Map<String, String> $default$classPathVolumeMounts() {
        return new TreeMap<String, String>();
    }

    private static String $default$pulsarTestImage() {
        return PulsarContainer.DEFAULT_IMAGE_NAME;
    }

    private static int $default$maxMessageSize() {
        return 0x500000;
    }

    PulsarClusterSpec(String clusterName, int numBookies, int numBrokers, int numProxies, int numFunctionWorkers, boolean enablePrestoWorker, boolean queryLastMessage, FunctionRuntimeType functionRuntimeType, Map<String, GenericContainer<?>> externalServices, boolean enableContainerLog, Map<String, String> classPathVolumeMounts, String pulsarTestImage, Map<String, String> proxyEnvs, Map<String, String> brokerEnvs, Map<String, String> proxyMountFiles, Map<String, String> brokerMountFiles, int maxMessageSize) {
        this.clusterName = clusterName;
        this.numBookies = numBookies;
        this.numBrokers = numBrokers;
        this.numProxies = numProxies;
        this.numFunctionWorkers = numFunctionWorkers;
        this.enablePrestoWorker = enablePrestoWorker;
        this.queryLastMessage = queryLastMessage;
        this.functionRuntimeType = functionRuntimeType;
        this.externalServices = externalServices;
        this.enableContainerLog = enableContainerLog;
        this.classPathVolumeMounts = classPathVolumeMounts;
        this.pulsarTestImage = pulsarTestImage;
        this.proxyEnvs = proxyEnvs;
        this.brokerEnvs = brokerEnvs;
        this.proxyMountFiles = proxyMountFiles;
        this.brokerMountFiles = brokerMountFiles;
        this.maxMessageSize = maxMessageSize;
    }

    public static PulsarClusterSpecBuilder builder() {
        return new PulsarClusterSpecBuilder();
    }

    public String clusterName() {
        return this.clusterName;
    }

    public int numBookies() {
        return this.numBookies;
    }

    public int numBrokers() {
        return this.numBrokers;
    }

    public int numProxies() {
        return this.numProxies;
    }

    public int numFunctionWorkers() {
        return this.numFunctionWorkers;
    }

    public boolean enablePrestoWorker() {
        return this.enablePrestoWorker;
    }

    public boolean queryLastMessage() {
        return this.queryLastMessage;
    }

    public FunctionRuntimeType functionRuntimeType() {
        return this.functionRuntimeType;
    }

    public Map<String, GenericContainer<?>> externalServices() {
        return this.externalServices;
    }

    public boolean enableContainerLog() {
        return this.enableContainerLog;
    }

    public Map<String, String> classPathVolumeMounts() {
        return this.classPathVolumeMounts;
    }

    public String pulsarTestImage() {
        return this.pulsarTestImage;
    }

    public Map<String, String> proxyEnvs() {
        return this.proxyEnvs;
    }

    public Map<String, String> brokerEnvs() {
        return this.brokerEnvs;
    }

    public Map<String, String> proxyMountFiles() {
        return this.proxyMountFiles;
    }

    public Map<String, String> brokerMountFiles() {
        return this.brokerMountFiles;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public PulsarClusterSpec clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public PulsarClusterSpec numBookies(int numBookies) {
        this.numBookies = numBookies;
        return this;
    }

    public PulsarClusterSpec numBrokers(int numBrokers) {
        this.numBrokers = numBrokers;
        return this;
    }

    public PulsarClusterSpec numProxies(int numProxies) {
        this.numProxies = numProxies;
        return this;
    }

    public PulsarClusterSpec numFunctionWorkers(int numFunctionWorkers) {
        this.numFunctionWorkers = numFunctionWorkers;
        return this;
    }

    public PulsarClusterSpec enablePrestoWorker(boolean enablePrestoWorker) {
        this.enablePrestoWorker = enablePrestoWorker;
        return this;
    }

    public PulsarClusterSpec queryLastMessage(boolean queryLastMessage) {
        this.queryLastMessage = queryLastMessage;
        return this;
    }

    public PulsarClusterSpec functionRuntimeType(FunctionRuntimeType functionRuntimeType) {
        this.functionRuntimeType = functionRuntimeType;
        return this;
    }

    public PulsarClusterSpec externalServices(Map<String, GenericContainer<?>> externalServices) {
        this.externalServices = externalServices;
        return this;
    }

    public PulsarClusterSpec enableContainerLog(boolean enableContainerLog) {
        this.enableContainerLog = enableContainerLog;
        return this;
    }

    public PulsarClusterSpec classPathVolumeMounts(Map<String, String> classPathVolumeMounts) {
        this.classPathVolumeMounts = classPathVolumeMounts;
        return this;
    }

    public PulsarClusterSpec pulsarTestImage(String pulsarTestImage) {
        this.pulsarTestImage = pulsarTestImage;
        return this;
    }

    public PulsarClusterSpec proxyEnvs(Map<String, String> proxyEnvs) {
        this.proxyEnvs = proxyEnvs;
        return this;
    }

    public PulsarClusterSpec brokerEnvs(Map<String, String> brokerEnvs) {
        this.brokerEnvs = brokerEnvs;
        return this;
    }

    public PulsarClusterSpec proxyMountFiles(Map<String, String> proxyMountFiles) {
        this.proxyMountFiles = proxyMountFiles;
        return this;
    }

    public PulsarClusterSpec brokerMountFiles(Map<String, String> brokerMountFiles) {
        this.brokerMountFiles = brokerMountFiles;
        return this;
    }

    public PulsarClusterSpec maxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public static class PulsarClusterSpecBuilder {
        private String clusterName;
        private boolean numBookies$set;
        private int numBookies$value;
        private boolean numBrokers$set;
        private int numBrokers$value;
        private boolean numProxies$set;
        private int numProxies$value;
        private boolean numFunctionWorkers$set;
        private int numFunctionWorkers$value;
        private boolean enablePrestoWorker$set;
        private boolean enablePrestoWorker$value;
        private boolean queryLastMessage$set;
        private boolean queryLastMessage$value;
        private boolean functionRuntimeType$set;
        private FunctionRuntimeType functionRuntimeType$value;
        private ArrayList<String> externalServices$key;
        private ArrayList<GenericContainer<?>> externalServices$value;
        private boolean enableContainerLog$set;
        private boolean enableContainerLog$value;
        private boolean classPathVolumeMounts$set;
        private Map<String, String> classPathVolumeMounts$value;
        private boolean pulsarTestImage$set;
        private String pulsarTestImage$value;
        private Map<String, String> proxyEnvs;
        private Map<String, String> brokerEnvs;
        private Map<String, String> proxyMountFiles;
        private Map<String, String> brokerMountFiles;
        private boolean maxMessageSize$set;
        private int maxMessageSize$value;

        PulsarClusterSpecBuilder() {
        }

        public PulsarClusterSpecBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public PulsarClusterSpecBuilder numBookies(int numBookies) {
            this.numBookies$value = numBookies;
            this.numBookies$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder numBrokers(int numBrokers) {
            this.numBrokers$value = numBrokers;
            this.numBrokers$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder numProxies(int numProxies) {
            this.numProxies$value = numProxies;
            this.numProxies$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder numFunctionWorkers(int numFunctionWorkers) {
            this.numFunctionWorkers$value = numFunctionWorkers;
            this.numFunctionWorkers$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder enablePrestoWorker(boolean enablePrestoWorker) {
            this.enablePrestoWorker$value = enablePrestoWorker;
            this.enablePrestoWorker$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder queryLastMessage(boolean queryLastMessage) {
            this.queryLastMessage$value = queryLastMessage;
            this.queryLastMessage$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder functionRuntimeType(FunctionRuntimeType functionRuntimeType) {
            this.functionRuntimeType$value = functionRuntimeType;
            this.functionRuntimeType$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder externalService(String externalServiceKey, GenericContainer<?> externalServiceValue) {
            if (this.externalServices$key == null) {
                this.externalServices$key = new ArrayList();
                this.externalServices$value = new ArrayList();
            }
            this.externalServices$key.add(externalServiceKey);
            this.externalServices$value.add(externalServiceValue);
            return this;
        }

        public PulsarClusterSpecBuilder externalServices(Map<? extends String, ? extends GenericContainer<?>> externalServices) {
            if (externalServices == null) {
                throw new NullPointerException("externalServices cannot be null");
            }
            if (this.externalServices$key == null) {
                this.externalServices$key = new ArrayList();
                this.externalServices$value = new ArrayList();
            }
            for (Map.Entry<String, GenericContainer<?>> $lombokEntry : externalServices.entrySet()) {
                this.externalServices$key.add($lombokEntry.getKey());
                this.externalServices$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PulsarClusterSpecBuilder clearExternalServices() {
            if (this.externalServices$key != null) {
                this.externalServices$key.clear();
                this.externalServices$value.clear();
            }
            return this;
        }

        public PulsarClusterSpecBuilder enableContainerLog(boolean enableContainerLog) {
            this.enableContainerLog$value = enableContainerLog;
            this.enableContainerLog$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder classPathVolumeMounts(Map<String, String> classPathVolumeMounts) {
            this.classPathVolumeMounts$value = classPathVolumeMounts;
            this.classPathVolumeMounts$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder pulsarTestImage(String pulsarTestImage) {
            this.pulsarTestImage$value = pulsarTestImage;
            this.pulsarTestImage$set = true;
            return this;
        }

        public PulsarClusterSpecBuilder proxyEnvs(Map<String, String> proxyEnvs) {
            this.proxyEnvs = proxyEnvs;
            return this;
        }

        public PulsarClusterSpecBuilder brokerEnvs(Map<String, String> brokerEnvs) {
            this.brokerEnvs = brokerEnvs;
            return this;
        }

        public PulsarClusterSpecBuilder proxyMountFiles(Map<String, String> proxyMountFiles) {
            this.proxyMountFiles = proxyMountFiles;
            return this;
        }

        public PulsarClusterSpecBuilder brokerMountFiles(Map<String, String> brokerMountFiles) {
            this.brokerMountFiles = brokerMountFiles;
            return this;
        }

        public PulsarClusterSpecBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize$value = maxMessageSize;
            this.maxMessageSize$set = true;
            return this;
        }

        public PulsarClusterSpec build() {
            Map<Object, Object> externalServices;
            switch (this.externalServices$key == null ? 0 : this.externalServices$key.size()) {
                case 0: {
                    externalServices = Collections.emptyMap();
                    break;
                }
                case 1: {
                    externalServices = Collections.singletonMap(this.externalServices$key.get(0), this.externalServices$value.get(0));
                    break;
                }
                default: {
                    externalServices = new LinkedHashMap(this.externalServices$key.size() < 0x40000000 ? 1 + this.externalServices$key.size() + (this.externalServices$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.externalServices$key.size(); ++$i) {
                        externalServices.put(this.externalServices$key.get($i), this.externalServices$value.get($i));
                    }
                    externalServices = Collections.unmodifiableMap(externalServices);
                }
            }
            int numBookies$value = this.numBookies$value;
            if (!this.numBookies$set) {
                numBookies$value = PulsarClusterSpec.$default$numBookies();
            }
            int numBrokers$value = this.numBrokers$value;
            if (!this.numBrokers$set) {
                numBrokers$value = PulsarClusterSpec.$default$numBrokers();
            }
            int numProxies$value = this.numProxies$value;
            if (!this.numProxies$set) {
                numProxies$value = PulsarClusterSpec.$default$numProxies();
            }
            int numFunctionWorkers$value = this.numFunctionWorkers$value;
            if (!this.numFunctionWorkers$set) {
                numFunctionWorkers$value = PulsarClusterSpec.$default$numFunctionWorkers();
            }
            boolean enablePrestoWorker$value = this.enablePrestoWorker$value;
            if (!this.enablePrestoWorker$set) {
                enablePrestoWorker$value = PulsarClusterSpec.$default$enablePrestoWorker();
            }
            boolean queryLastMessage$value = this.queryLastMessage$value;
            if (!this.queryLastMessage$set) {
                queryLastMessage$value = PulsarClusterSpec.$default$queryLastMessage();
            }
            FunctionRuntimeType functionRuntimeType$value = this.functionRuntimeType$value;
            if (!this.functionRuntimeType$set) {
                functionRuntimeType$value = PulsarClusterSpec.$default$functionRuntimeType();
            }
            boolean enableContainerLog$value = this.enableContainerLog$value;
            if (!this.enableContainerLog$set) {
                enableContainerLog$value = PulsarClusterSpec.$default$enableContainerLog();
            }
            Map classPathVolumeMounts$value = this.classPathVolumeMounts$value;
            if (!this.classPathVolumeMounts$set) {
                classPathVolumeMounts$value = PulsarClusterSpec.$default$classPathVolumeMounts();
            }
            String pulsarTestImage$value = this.pulsarTestImage$value;
            if (!this.pulsarTestImage$set) {
                pulsarTestImage$value = PulsarClusterSpec.$default$pulsarTestImage();
            }
            int maxMessageSize$value = this.maxMessageSize$value;
            if (!this.maxMessageSize$set) {
                maxMessageSize$value = PulsarClusterSpec.$default$maxMessageSize();
            }
            return new PulsarClusterSpec(this.clusterName, numBookies$value, numBrokers$value, numProxies$value, numFunctionWorkers$value, enablePrestoWorker$value, queryLastMessage$value, functionRuntimeType$value, externalServices, enableContainerLog$value, classPathVolumeMounts$value, pulsarTestImage$value, this.proxyEnvs, this.brokerEnvs, this.proxyMountFiles, this.brokerMountFiles, maxMessageSize$value);
        }

        public String toString() {
            return "PulsarClusterSpec.PulsarClusterSpecBuilder(clusterName=" + this.clusterName + ", numBookies$value=" + this.numBookies$value + ", numBrokers$value=" + this.numBrokers$value + ", numProxies$value=" + this.numProxies$value + ", numFunctionWorkers$value=" + this.numFunctionWorkers$value + ", enablePrestoWorker$value=" + this.enablePrestoWorker$value + ", queryLastMessage$value=" + this.queryLastMessage$value + ", functionRuntimeType$value=" + (Object)((Object)this.functionRuntimeType$value) + ", externalServices$key=" + this.externalServices$key + ", externalServices$value=" + this.externalServices$value + ", enableContainerLog$value=" + this.enableContainerLog$value + ", classPathVolumeMounts$value=" + this.classPathVolumeMounts$value + ", pulsarTestImage$value=" + this.pulsarTestImage$value + ", proxyEnvs=" + this.proxyEnvs + ", brokerEnvs=" + this.brokerEnvs + ", proxyMountFiles=" + this.proxyMountFiles + ", brokerMountFiles=" + this.brokerMountFiles + ", maxMessageSize$value=" + this.maxMessageSize$value + ")";
        }
    }
}

