/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.suites;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class PulsarTieredStorageTestSuite
extends PulsarClusterTestBase {
    private static final Logger log = LoggerFactory.getLogger(PulsarTieredStorageTestSuite.class);
    protected static final int ENTRIES_PER_LEDGER = 1024;

    @Override
    @BeforeClass(alwaysRun=true)
    public final void setupCluster() throws Exception {
        String clusterName = Stream.of(((Object)((Object)this)).getClass().getSimpleName(), PulsarTieredStorageTestSuite.randomName(5)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("-"));
        PulsarClusterSpec spec = PulsarClusterSpec.builder().numBookies(2).numBrokers(1).clusterName(clusterName).build();
        this.setupCluster(spec);
    }

    @Override
    @AfterClass(alwaysRun=true)
    public final void tearDownCluster() throws Exception {
        super.tearDownCluster();
    }

    protected abstract Map<String, String> getEnv();

    @Override
    protected void beforeStartCluster() throws Exception {
        super.beforeStartCluster();
        for (BrokerContainer brokerContainer : this.pulsarCluster.getBrokers()) {
            this.getEnv().forEach((arg_0, arg_1) -> ((BrokerContainer)brokerContainer).withEnv(arg_0, arg_1));
        }
    }
}

