/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.proxy;

import java.util.Collections;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.tests.integration.suites.PulsarTestSuite;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestProxy
extends PulsarTestSuite {
    private static final Logger log = LoggerFactory.getLogger(TestProxy.class);

    @Override
    protected PulsarClusterSpec.PulsarClusterSpecBuilder beforeSetupCluster(String clusterName, PulsarClusterSpec.PulsarClusterSpecBuilder specBuilder) {
        return super.beforeSetupCluster(clusterName, specBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testProxy(String serviceUrl, String httpServiceUrl) throws Exception {
        String tenant = "proxy-test-" + TestProxy.randomName(10);
        String namespace = tenant + "/ns1";
        String topic = "persistent://" + namespace + "/topic1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(httpServiceUrl).build();
        try {
            admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.emptySet(), Collections.singleton(this.pulsarCluster.getClusterName())));
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            PulsarClient client = PulsarClient.builder().serviceUrl(serviceUrl).build();
            try {
                client.newConsumer().topic(new String[]{topic}).subscriptionName("sub1").subscribe().close();
                Producer producer = client.newProducer(Schema.STRING).topic(topic).create();
                try {
                    producer.send((Object)"content-0");
                    producer.send((Object)"content-1");
                    for (int i = 0; i < 10; ++i) {
                        TopicStats stats = admin.topics().getStats(topic);
                        Assert.assertEquals((int)stats.getPublishers().size(), (int)1);
                    }
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }

    @Test
    public void testProxyWithServiceDiscovery() throws Exception {
        this.testProxy(this.pulsarCluster.getPlainTextServiceUrl(), this.pulsarCluster.getHttpServiceUrl());
    }

    @Test
    public void testProxyWithNoServiceDiscoveryProxyConnectsViaURL() throws Exception {
        this.testProxy(this.pulsarCluster.getProxy().getPlainTextServiceUrl(), this.pulsarCluster.getProxy().getHttpServiceUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyRequestBodyRedirect() throws Exception {
        String tenant = "proxy-test-" + TestProxy.randomName(10);
        String namespace = tenant + "/ns1";
        String topic = "persistent://" + namespace + "/topic1";
        PulsarAdmin admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsarCluster.getProxy().getHttpServiceUrl()).build();
        try {
            admin.tenants().createTenant(tenant, (TenantInfo)new TenantInfoImpl(Collections.emptySet(), Collections.singleton(this.pulsarCluster.getClusterName())));
            admin.namespaces().createNamespace(namespace, Collections.singleton(this.pulsarCluster.getClusterName()));
            for (int i = 0; i < 10; ++i) {
                admin.topics().createSubscription(topic, "test-" + i, MessageId.earliest);
            }
        }
        finally {
            if (Collections.singletonList(admin).get(0) != null) {
                admin.close();
            }
        }
    }
}

