/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.messaging;

import java.util.function.Supplier;
import org.apache.pulsar.tests.integration.messaging.TopicMessagingBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class NonPersistentTopicMessagingTest
extends TopicMessagingBase {
    private static final Logger log = LoggerFactory.getLogger(NonPersistentTopicMessagingTest.class);

    @Test(dataProvider="ServiceUrls")
    public void testNonPartitionedTopicMessagingWithExclusive(Supplier<String> serviceUrl) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithExclusive(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testPartitionedTopicMessagingWithExclusive(Supplier<String> serviceUrl) throws Exception {
        this.partitionedTopicSendAndReceiveWithExclusive(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testNonPartitionedTopicMessagingWithFailover(Supplier<String> serviceUrl) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithFailover(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testPartitionedTopicMessagingWithFailover(Supplier<String> serviceUrl) throws Exception {
        this.partitionedTopicSendAndReceiveWithFailover(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testNonPartitionedTopicMessagingWithShared(Supplier<String> serviceUrl) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithShared(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testPartitionedTopicMessagingWithShared(Supplier<String> serviceUrl) throws Exception {
        this.partitionedTopicSendAndReceiveWithShared(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testNonPartitionedTopicMessagingWithKeyShared(Supplier<String> serviceUrl) throws Exception {
        this.nonPartitionedTopicSendAndReceiveWithKeyShared(serviceUrl.get(), false);
    }

    @Test(dataProvider="ServiceUrls")
    public void testPartitionedTopicMessagingWithKeyShared(Supplier<String> serviceUrl) throws Exception {
        this.partitionedTopicSendAndReceiveWithKeyShared(serviceUrl.get(), false);
    }
}

