/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.functions.utils;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;

public class CommandGenerator {
    private static final long MB = 0x100000L;
    private static final long JAVA_RUNTIME_RAM_BYTES = 0x8000000L;
    private String functionName;
    private String tenant = "public";
    private String namespace = "default";
    private String functionClassName;
    private String sourceTopic;
    private String sourceTopicPattern;
    private Map<String, String> customSereSourceTopics;
    private String sinkTopic;
    private String logTopic;
    private String outputSerDe;
    private String processingGuarantees;
    private Runtime runtime;
    private Integer parallelism;
    private String adminUrl;
    private String batchBuilder;
    private Integer windowLengthCount;
    private Long windowLengthDurationMs;
    private Integer slidingIntervalCount;
    private Long slidingIntervalDurationMs;
    private String customSchemaInputs;
    private String schemaType;
    private SubscriptionInitialPosition subscriptionInitialPosition;
    private Map<String, String> userConfig = new HashMap<String, String>();
    public static final String JAVAJAR = "/pulsar/examples/java-test-functions.jar";
    public static final String PYTHONBASE = "/pulsar/examples/python-examples/";
    public static final String GOBASE = "/pulsar/examples/go-examples/";

    public static CommandGenerator createDefaultGenerator(String sourceTopic, String functionClassName) {
        CommandGenerator generator = new CommandGenerator();
        generator.setSourceTopic(sourceTopic);
        generator.setFunctionClassName(functionClassName);
        generator.setRuntime(Runtime.JAVA);
        return generator;
    }

    public static CommandGenerator createTopicPatternGenerator(String sourceTopicPattern, String functionClassName) {
        CommandGenerator generator = new CommandGenerator();
        generator.setSourceTopicPattern(sourceTopicPattern);
        generator.setFunctionClassName(functionClassName);
        generator.setRuntime(Runtime.JAVA);
        return generator;
    }

    public String generateLocalRunCommand(String codeFile) {
        StringBuilder commandBuilder = new StringBuilder("/pulsar/bin/pulsar-admin");
        commandBuilder.append(" functions localrun");
        if (this.adminUrl != null) {
            commandBuilder.append(" --broker-service-url " + this.adminUrl);
        }
        if (this.tenant != null) {
            commandBuilder.append(" --tenant " + this.tenant);
        }
        if (this.namespace != null) {
            commandBuilder.append(" --namespace " + this.namespace);
        }
        if (this.functionName != null) {
            commandBuilder.append(" --name " + this.functionName);
        }
        if (this.runtime != Runtime.GO) {
            commandBuilder.append(" --className " + this.functionClassName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sourceTopic)) {
            commandBuilder.append(" --inputs " + this.sourceTopic);
        }
        if (this.sinkTopic != null) {
            commandBuilder.append(" --output " + this.sinkTopic);
        }
        if (this.customSchemaInputs != null) {
            commandBuilder.append(" --custom-schema-inputs '" + this.customSchemaInputs + "'");
        }
        if (this.schemaType != null) {
            commandBuilder.append(" --schema-type " + this.schemaType);
        }
        if (this.subscriptionInitialPosition != null) {
            commandBuilder.append(" --subs-position " + this.subscriptionInitialPosition.name());
        }
        switch (this.runtime) {
            case JAVA: {
                commandBuilder.append(" --jar /pulsar/examples/java-test-functions.jar");
                break;
            }
            case PYTHON: {
                if (codeFile != null) {
                    commandBuilder.append(" --py /pulsar/examples/python-examples/" + codeFile);
                    break;
                }
                commandBuilder.append(" --py /pulsar/examples/python-examples/");
                break;
            }
            case GO: {
                if (codeFile != null) {
                    commandBuilder.append(" --go /pulsar/examples/go-examples/" + codeFile);
                    break;
                }
                commandBuilder.append(" --go /pulsar/examples/go-examples/");
            }
        }
        return commandBuilder.toString();
    }

    public String generateCreateFunctionCommand() {
        return this.generateCreateFunctionCommand(null);
    }

    public String generateCreateFunctionCommand(String codeFile) {
        StringBuilder commandBuilder = new StringBuilder("/pulsar/bin/pulsar-admin");
        if (this.adminUrl != null) {
            commandBuilder.append(" --admin-url ");
            commandBuilder.append(this.adminUrl);
        }
        commandBuilder.append(" functions create");
        if (this.tenant != null) {
            commandBuilder.append(" --tenant " + this.tenant);
        }
        if (this.namespace != null) {
            commandBuilder.append(" --namespace " + this.namespace);
        }
        if (this.functionName != null) {
            commandBuilder.append(" --name " + this.functionName);
        }
        if (this.runtime != Runtime.GO) {
            commandBuilder.append(" --className " + this.functionClassName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sourceTopic)) {
            commandBuilder.append(" --inputs " + this.sourceTopic);
        }
        if (this.sourceTopicPattern != null) {
            commandBuilder.append(" --topics-pattern " + this.sourceTopicPattern);
        }
        if (this.logTopic != null) {
            commandBuilder.append(" --logTopic " + this.logTopic);
        }
        if (this.batchBuilder != null) {
            commandBuilder.append("--batch-builder" + this.batchBuilder);
        }
        if (this.customSereSourceTopics != null && !this.customSereSourceTopics.isEmpty()) {
            commandBuilder.append(" --customSerdeInputs '" + new Gson().toJson(this.customSereSourceTopics) + "'");
        }
        if (this.sinkTopic != null) {
            commandBuilder.append(" --output " + this.sinkTopic);
        }
        if (this.outputSerDe != null) {
            commandBuilder.append(" --outputSerdeClassName " + this.outputSerDe);
        }
        if (this.processingGuarantees != null) {
            commandBuilder.append(" --processingGuarantees " + this.processingGuarantees);
        }
        if (!this.userConfig.isEmpty()) {
            commandBuilder.append(" --userConfig '" + new Gson().toJson(this.userConfig) + "'");
        }
        if (this.parallelism != null) {
            commandBuilder.append(" --parallelism " + this.parallelism);
        }
        if (this.windowLengthCount != null) {
            commandBuilder.append(" --windowLengthCount " + this.windowLengthCount);
        }
        if (this.windowLengthDurationMs != null) {
            commandBuilder.append(" --windowLengthDurationMs " + this.windowLengthDurationMs);
        }
        if (this.slidingIntervalCount != null) {
            commandBuilder.append(" --slidingIntervalCount " + this.slidingIntervalCount);
        }
        if (this.slidingIntervalDurationMs != null) {
            commandBuilder.append(" --slidingIntervalDurationMs " + this.slidingIntervalDurationMs);
        }
        if (this.customSchemaInputs != null) {
            commandBuilder.append(" --custom-schema-inputs '" + this.customSchemaInputs + "'");
        }
        if (this.schemaType != null) {
            commandBuilder.append(" --schema-type " + this.schemaType);
        }
        if (this.subscriptionInitialPosition != null) {
            commandBuilder.append(" --subs-position " + this.subscriptionInitialPosition.name());
        }
        switch (this.runtime) {
            case JAVA: {
                commandBuilder.append(" --jar /pulsar/examples/java-test-functions.jar");
                commandBuilder.append(" --ram 134217728");
                break;
            }
            case PYTHON: {
                if (codeFile != null) {
                    commandBuilder.append(" --py /pulsar/examples/python-examples/" + codeFile);
                    break;
                }
                commandBuilder.append(" --py /pulsar/examples/python-examples/");
                break;
            }
            case GO: {
                if (codeFile != null) {
                    commandBuilder.append(" --go /pulsar/examples/go-examples/" + codeFile);
                    break;
                }
                commandBuilder.append(" --go /pulsar/examples/go-examples/");
            }
        }
        return commandBuilder.toString();
    }

    public String generateUpdateFunctionCommand() {
        return this.generateUpdateFunctionCommand(null);
    }

    public String generateUpdateFunctionCommand(String codeFile) {
        StringBuilder commandBuilder = new StringBuilder();
        if (this.adminUrl == null) {
            commandBuilder.append("/pulsar/bin/pulsar-admin functions update");
        } else {
            commandBuilder.append("/pulsar/bin/pulsar-admin");
            commandBuilder.append(" --admin-url ");
            commandBuilder.append(this.adminUrl);
            commandBuilder.append(" functions update");
        }
        if (this.tenant != null) {
            commandBuilder.append(" --tenant " + this.tenant);
        }
        if (this.namespace != null) {
            commandBuilder.append(" --namespace " + this.namespace);
        }
        if (this.functionName != null) {
            commandBuilder.append(" --name " + this.functionName);
        }
        if (this.functionClassName != null) {
            commandBuilder.append(" --className " + this.functionClassName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sourceTopic)) {
            commandBuilder.append(" --inputs " + this.sourceTopic);
        }
        if (this.customSereSourceTopics != null && !this.customSereSourceTopics.isEmpty()) {
            commandBuilder.append(" --customSerdeInputs '" + new Gson().toJson(this.customSereSourceTopics) + "'");
        }
        if (this.batchBuilder != null) {
            commandBuilder.append("--batch-builder" + this.batchBuilder);
        }
        if (this.sinkTopic != null) {
            commandBuilder.append(" --output " + this.sinkTopic);
        }
        if (this.logTopic != null) {
            commandBuilder.append(" --logTopic " + this.logTopic);
        }
        if (this.outputSerDe != null) {
            commandBuilder.append(" --outputSerdeClassName " + this.outputSerDe);
        }
        if (this.processingGuarantees != null) {
            commandBuilder.append(" --processingGuarantees " + this.processingGuarantees);
        }
        if (!this.userConfig.isEmpty()) {
            commandBuilder.append(" --userConfig '" + new Gson().toJson(this.userConfig) + "'");
        }
        if (this.parallelism != null) {
            commandBuilder.append(" --parallelism " + this.parallelism);
        }
        if (this.windowLengthCount != null) {
            commandBuilder.append(" --windowLengthCount " + this.windowLengthCount);
        }
        if (this.windowLengthDurationMs != null) {
            commandBuilder.append(" --windowLengthDurationMs " + this.windowLengthDurationMs);
        }
        if (this.slidingIntervalCount != null) {
            commandBuilder.append(" --slidingIntervalCount " + this.slidingIntervalCount);
        }
        if (this.slidingIntervalDurationMs != null) {
            commandBuilder.append(" --slidingIntervalDurationMs " + this.slidingIntervalDurationMs);
        }
        if (this.customSchemaInputs != null) {
            commandBuilder.append(" --custom-schema-inputs '" + this.customSchemaInputs + "'");
        }
        if (this.schemaType != null) {
            commandBuilder.append(" --schema-type " + this.schemaType);
        }
        if (this.subscriptionInitialPosition != null) {
            commandBuilder.append(" --subs-position " + this.subscriptionInitialPosition.name());
        }
        if (codeFile != null) {
            switch (this.runtime) {
                case JAVA: {
                    commandBuilder.append(" --jar /pulsar/examples/java-test-functions.jar");
                    commandBuilder.append(" --ram 134217728");
                    break;
                }
                case PYTHON: {
                    if (codeFile != null) {
                        commandBuilder.append(" --py /pulsar/examples/python-examples/" + codeFile);
                        break;
                    }
                    commandBuilder.append(" --py /pulsar/examples/python-examples/");
                    break;
                }
                case GO: {
                    if (codeFile != null) {
                        commandBuilder.append(" --go /pulsar/examples/go-examples/" + codeFile);
                        break;
                    }
                    commandBuilder.append(" --go /pulsar/examples/go-examples/");
                }
            }
        }
        return commandBuilder.toString();
    }

    public String genereateDeleteFunctionCommand() {
        StringBuilder commandBuilder = new StringBuilder("/pulsar/bin/pulsar-admin functions delete");
        if (this.tenant != null) {
            commandBuilder.append(" --tenant " + this.tenant);
        }
        if (this.namespace != null) {
            commandBuilder.append(" --namespace " + this.namespace);
        }
        if (this.functionName != null) {
            commandBuilder.append(" --name " + this.functionName);
        }
        return commandBuilder.toString();
    }

    public String generateTriggerFunctionCommand(String triggerValue) {
        StringBuilder commandBuilder = new StringBuilder("/pulsar/bin/pulsar-admin functions trigger");
        if (this.tenant != null) {
            commandBuilder.append(" --tenant " + this.tenant);
        }
        if (this.namespace != null) {
            commandBuilder.append(" --namespace " + this.namespace);
        }
        if (this.functionName != null) {
            commandBuilder.append(" --name " + this.functionName);
        }
        commandBuilder.append(" --triggerValue " + triggerValue);
        return commandBuilder.toString();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFunctionClassName() {
        return this.functionClassName;
    }

    public String getSourceTopic() {
        return this.sourceTopic;
    }

    public String getSourceTopicPattern() {
        return this.sourceTopicPattern;
    }

    public Map<String, String> getCustomSereSourceTopics() {
        return this.customSereSourceTopics;
    }

    public String getSinkTopic() {
        return this.sinkTopic;
    }

    public String getLogTopic() {
        return this.logTopic;
    }

    public String getOutputSerDe() {
        return this.outputSerDe;
    }

    public String getProcessingGuarantees() {
        return this.processingGuarantees;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getBatchBuilder() {
        return this.batchBuilder;
    }

    public Integer getWindowLengthCount() {
        return this.windowLengthCount;
    }

    public Long getWindowLengthDurationMs() {
        return this.windowLengthDurationMs;
    }

    public Integer getSlidingIntervalCount() {
        return this.slidingIntervalCount;
    }

    public Long getSlidingIntervalDurationMs() {
        return this.slidingIntervalDurationMs;
    }

    public String getCustomSchemaInputs() {
        return this.customSchemaInputs;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public Map<String, String> getUserConfig() {
        return this.userConfig;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFunctionClassName(String functionClassName) {
        this.functionClassName = functionClassName;
    }

    public void setSourceTopic(String sourceTopic) {
        this.sourceTopic = sourceTopic;
    }

    public void setSourceTopicPattern(String sourceTopicPattern) {
        this.sourceTopicPattern = sourceTopicPattern;
    }

    public void setCustomSereSourceTopics(Map<String, String> customSereSourceTopics) {
        this.customSereSourceTopics = customSereSourceTopics;
    }

    public void setSinkTopic(String sinkTopic) {
        this.sinkTopic = sinkTopic;
    }

    public void setLogTopic(String logTopic) {
        this.logTopic = logTopic;
    }

    public void setOutputSerDe(String outputSerDe) {
        this.outputSerDe = outputSerDe;
    }

    public void setProcessingGuarantees(String processingGuarantees) {
        this.processingGuarantees = processingGuarantees;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setBatchBuilder(String batchBuilder) {
        this.batchBuilder = batchBuilder;
    }

    public void setWindowLengthCount(Integer windowLengthCount) {
        this.windowLengthCount = windowLengthCount;
    }

    public void setWindowLengthDurationMs(Long windowLengthDurationMs) {
        this.windowLengthDurationMs = windowLengthDurationMs;
    }

    public void setSlidingIntervalCount(Integer slidingIntervalCount) {
        this.slidingIntervalCount = slidingIntervalCount;
    }

    public void setSlidingIntervalDurationMs(Long slidingIntervalDurationMs) {
        this.slidingIntervalDurationMs = slidingIntervalDurationMs;
    }

    public void setCustomSchemaInputs(String customSchemaInputs) {
        this.customSchemaInputs = customSchemaInputs;
    }

    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public void setUserConfig(Map<String, String> userConfig) {
        this.userConfig = userConfig;
    }

    public String toString() {
        return "CommandGenerator(functionName=" + this.getFunctionName() + ", tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", functionClassName=" + this.getFunctionClassName() + ", sourceTopic=" + this.getSourceTopic() + ", sourceTopicPattern=" + this.getSourceTopicPattern() + ", customSereSourceTopics=" + this.getCustomSereSourceTopics() + ", sinkTopic=" + this.getSinkTopic() + ", logTopic=" + this.getLogTopic() + ", outputSerDe=" + this.getOutputSerDe() + ", processingGuarantees=" + this.getProcessingGuarantees() + ", runtime=" + (Object)((Object)this.getRuntime()) + ", parallelism=" + this.getParallelism() + ", adminUrl=" + this.getAdminUrl() + ", batchBuilder=" + this.getBatchBuilder() + ", windowLengthCount=" + this.getWindowLengthCount() + ", windowLengthDurationMs=" + this.getWindowLengthDurationMs() + ", slidingIntervalCount=" + this.getSlidingIntervalCount() + ", slidingIntervalDurationMs=" + this.getSlidingIntervalDurationMs() + ", customSchemaInputs=" + this.getCustomSchemaInputs() + ", schemaType=" + this.getSchemaType() + ", subscriptionInitialPosition=" + this.getSubscriptionInitialPosition() + ", userConfig=" + this.getUserConfig() + ")";
    }

    public static enum Runtime {
        JAVA,
        PYTHON,
        GO;

    }
}

