/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.containers;

import org.apache.pulsar.tests.integration.containers.ChaosContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class RabbitMQContainer
extends ChaosContainer<RabbitMQContainer> {
    public static final String NAME = "RabbitMQ";
    public static final Integer[] PORTS = new Integer[]{5672};
    private static final String IMAGE_NAME = "rabbitmq:3.8-management";
    private String networkAlias;

    public RabbitMQContainer(String clusterName, String networkAlias) {
        super(clusterName, IMAGE_NAME);
        this.networkAlias = networkAlias;
    }

    @Override
    protected void configure() {
        super.configure();
        ((RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)this.withNetworkAliases(new String[]{this.networkAlias})).withExposedPorts(PORTS)).withCreateContainerCmdModifier(createContainerCmd -> {
            createContainerCmd.withHostName(NAME);
            createContainerCmd.withName(this.clusterName + "-" + NAME);
        })).waitingFor((WaitStrategy)new HostPortWaitStrategy());
    }
}

