/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.testcontainers.shaded.org.apache.commons.lang.RandomStringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PackagesCliTest
extends TestRetrySupport {
    private static final String clusterNamePrefix = "packages-service";
    private PulsarCluster pulsarCluster;

    @BeforeClass(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName(String.format("%s-%s", clusterNamePrefix, RandomStringUtils.randomAlphabetic((int)6))).brokerEnvs(this.getPackagesManagementServiceEnvs()).build();
        this.pulsarCluster = PulsarCluster.forSpec(spec);
        this.pulsarCluster.start();
    }

    @AfterClass(alwaysRun=true)
    public final void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
            this.pulsarCluster = null;
        }
    }

    private Map<String, String> getPackagesManagementServiceEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("enablePackagesManagement", "true");
        envs.put("packagesManagementLedgerRootPath", "/ledgers");
        return envs;
    }

    @Test(timeOut=300000L)
    public void testPackagesOperationsWithoutUploadingPackages() throws Exception {
        ContainerExecResult result = this.runPackagesCommand("list", "--type", "function", "public/default");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = this.runPackagesCommand("list-versions", "function://public/default/test");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        try {
            result = this.runPackagesCommand("download", "function://public/default/test@v1", "--path", "test-admin");
            Assert.fail((String)"this command should be failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeOut=480000L)
    public void testPackagesOperationsWithUploadingPackages() throws Exception {
        String testPackageName = "function://public/default/test@v1";
        ContainerExecResult result = this.runPackagesCommand("upload", "--description", "a test package", "--path", "/pulsar/bin/pulsar-admin", testPackageName);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        BrokerContainer container = this.pulsarCluster.getBroker(0);
        String downloadFile = "tmp-file-" + RandomStringUtils.randomAlphabetic((int)8);
        String[] downloadCmd = new String[]{"/pulsar/bin/pulsar-admin", "packages", "download", "--path", downloadFile, testPackageName};
        result = container.execCmd(downloadCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        String[] diffCmd = new String[]{"diff", "/pulsar/bin/pulsar-admin", downloadFile};
        result = container.execCmd(diffCmd);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = this.runPackagesCommand("get-metadata", testPackageName);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("a test package"));
        result = this.runPackagesCommand("list", "--type", "function", "public/default");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("test"));
        result = this.runPackagesCommand("list-versions", "function://public/default/test");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("v1"));
        String contact = "test@apache.org";
        result = this.runPackagesCommand("update-metadata", "--description", "a test package", "--contact", contact, "-PpropertyA=A", testPackageName);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = this.runPackagesCommand("get-metadata", testPackageName);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        Assert.assertFalse((boolean)result.getStdout().isEmpty());
        Assert.assertTrue((boolean)result.getStdout().contains("a test package"));
        Assert.assertTrue((boolean)result.getStdout().contains(contact));
        Assert.assertTrue((boolean)result.getStdout().contains("propertyA"));
        result = this.runPackagesCommand("delete", testPackageName);
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result = this.runPackagesCommand("list-versions", "function://public/default/test");
        Assert.assertEquals((long)result.getExitCode(), (long)0L);
        result.assertNoStdout();
    }

    private ContainerExecResult runPackagesCommand(String ... commands) throws Exception {
        String[] cmds = new String[commands.length + 1];
        cmds[0] = "packages";
        System.arraycopy(commands, 0, cmds, 1, commands.length);
        return this.pulsarCluster.runAdminCommandOnAnyBroker(cmds);
    }
}

