/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.tests.integration.containers.BKContainer;
import org.apache.pulsar.tests.integration.containers.BrokerContainer;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.topologies.PulsarCluster;
import org.apache.pulsar.tests.integration.topologies.PulsarClusterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HealthCheckTest
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckTest.class);
    private final PulsarClusterSpec spec = PulsarClusterSpec.builder().clusterName("HealthCheckTest-" + UUID.randomUUID().toString().substring(0, 8)).numProxies(0).numFunctionWorkers(0).enablePrestoWorker(false).build();
    private PulsarCluster pulsarCluster = null;

    @BeforeMethod(alwaysRun=true)
    public final void setup() throws Exception {
        this.incrementSetupNumber();
        this.pulsarCluster = PulsarCluster.forSpec(this.spec);
        this.pulsarCluster.start();
    }

    @AfterMethod(alwaysRun=true)
    public final void cleanup() {
        this.markCurrentSetupNumberCleaned();
        if (this.pulsarCluster != null) {
            this.pulsarCluster.stop();
            this.pulsarCluster = null;
        }
    }

    @Test
    public void testEverythingOK() throws Exception {
        for (BrokerContainer b : this.pulsarCluster.getBrokers()) {
            ContainerExecResult result = b.execCmd("/pulsar/bin/pulsar-admin", "brokers", "healthcheck");
            Assert.assertEquals((long)result.getExitCode(), (long)0L);
            Assert.assertEquals((String)result.getStdout().trim(), (String)"ok");
        }
    }

    private void assertHealthcheckFailure() throws Exception {
        for (BrokerContainer b : this.pulsarCluster.getBrokers()) {
            try {
                b.execCmd("/pulsar/bin/pulsar-admin", "brokers", "healthcheck");
                Assert.fail((String)"Should always fail");
            }
            catch (ContainerExecException e) {
                Assert.assertEquals((long)e.getResult().getExitCode(), (long)1L);
            }
        }
    }

    @Test
    public void testZooKeeperDown() throws Exception {
        this.pulsarCluster.getZooKeeper().execCmd("pkill", "-STOP", "-f", "QuorumPeerMain");
        this.assertHealthcheckFailure();
    }

    @Test
    public void testBookKeeperDown() throws Exception {
        for (BKContainer b : this.pulsarCluster.getBookies()) {
            b.execCmd("pkill", "-STOP", "-f", "Main");
        }
        this.assertHealthcheckFailure();
    }

    private static Map<String, String> parseOutput(String output) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(output, (TypeReference)new TypeReference<HashMap<String, String>>(){});
    }
}

