/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.storm;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.client.api.ClientConfiguration;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerConfiguration;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pulsar-storm-shade.com.google.common.collect.Maps;

public class SharedPulsarClient {
    private static final Logger LOG = LoggerFactory.getLogger(SharedPulsarClient.class);
    private static final ConcurrentMap<String, SharedPulsarClient> instances = Maps.newConcurrentMap();
    private final String componentId;
    private final PulsarClient client;
    private final AtomicInteger counter = new AtomicInteger();
    private Consumer consumer;
    private Producer producer;

    private SharedPulsarClient(String componentId, String serviceUrl, ClientConfiguration clientConf) throws PulsarClientException {
        this.client = PulsarClient.create((String)serviceUrl, (ClientConfiguration)clientConf);
        this.componentId = componentId;
    }

    public static SharedPulsarClient get(String componentId, String serviceUrl, ClientConfiguration clientConf) throws PulsarClientException {
        AtomicReference exception = new AtomicReference();
        instances.computeIfAbsent(componentId, pulsarClient -> {
            SharedPulsarClient sharedPulsarClient = null;
            try {
                sharedPulsarClient = new SharedPulsarClient(componentId, serviceUrl, clientConf);
                LOG.info("[{}] Created a new Pulsar Client.", (Object)componentId);
            }
            catch (PulsarClientException e) {
                exception.set(e);
            }
            return sharedPulsarClient;
        });
        if (exception.get() != null) {
            throw (PulsarClientException)((Object)exception.get());
        }
        return (SharedPulsarClient)instances.get(componentId);
    }

    public PulsarClient getClient() {
        this.counter.incrementAndGet();
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getSharedConsumer(String topic, String subscription, ConsumerConfiguration consumerConf) throws PulsarClientException {
        this.counter.incrementAndGet();
        SharedPulsarClient sharedPulsarClient = this;
        synchronized (sharedPulsarClient) {
            if (this.consumer == null) {
                this.consumer = this.client.subscribe(topic, subscription, consumerConf);
                LOG.info("[{}] Created a new Pulsar Consumer on {}", (Object)this.componentId, (Object)topic);
            } else {
                LOG.info("[{}] Using a shared consumer on {}", (Object)this.componentId, (Object)topic);
            }
        }
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer getSharedProducer(String topic, ProducerConfiguration producerConf) throws PulsarClientException {
        this.counter.incrementAndGet();
        SharedPulsarClient sharedPulsarClient = this;
        synchronized (sharedPulsarClient) {
            if (this.producer == null) {
                this.producer = this.client.createProducer(topic, producerConf);
                LOG.info("[{}] Created a new Pulsar Producer on {}", (Object)this.componentId, (Object)topic);
            } else {
                LOG.info("[{}] Using a shared producer on {}", (Object)this.componentId, (Object)topic);
            }
        }
        return this.producer;
    }

    public void close() throws PulsarClientException {
        if (this.counter.decrementAndGet() <= 0 && this.client != null) {
            this.client.close();
            instances.remove(this.componentId);
            LOG.info("[{}] Closed Pulsar Client", (Object)this.componentId);
        }
    }
}

