/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.storm;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.storm.MessageToValuesMapper;
import org.apache.pulsar.storm.PulsarStormConfiguration;
import pulsar-storm-shade.com.google.common.base.Preconditions;

public class PulsarSpoutConfiguration
extends PulsarStormConfiguration {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_FAILED_RETRIES_TIMEOUT_NANO = TimeUnit.SECONDS.toNanos(60L);
    public static final int DEFAULT_MAX_FAILED_RETRIES = -1;
    private String subscriptionName = null;
    private MessageToValuesMapper messageToValuesMapper = null;
    private long failedRetriesTimeoutNano = DEFAULT_FAILED_RETRIES_TIMEOUT_NANO;
    private int maxFailedRetries = -1;
    private boolean sharedConsumerEnabled = false;

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public MessageToValuesMapper getMessageToValuesMapper() {
        return this.messageToValuesMapper;
    }

    public void setMessageToValuesMapper(MessageToValuesMapper mapper) {
        this.messageToValuesMapper = Preconditions.checkNotNull(mapper);
    }

    public long getFailedRetriesTimeout(TimeUnit unit) {
        return unit.convert(this.failedRetriesTimeoutNano, TimeUnit.NANOSECONDS);
    }

    public void setFailedRetriesTimeout(long failedRetriesTimeout, TimeUnit unit) {
        this.failedRetriesTimeoutNano = unit.toNanos(failedRetriesTimeout);
    }

    public int getMaxFailedRetries() {
        return this.maxFailedRetries;
    }

    public void setMaxFailedRetries(int maxFailedRetries) {
        this.maxFailedRetries = maxFailedRetries;
    }

    public boolean isSharedConsumerEnabled() {
        return this.sharedConsumerEnabled;
    }

    public void setSharedConsumerEnabled(boolean sharedConsumerEnabled) {
        this.sharedConsumerEnabled = sharedConsumerEnabled;
    }
}

